/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;

public class ArrayWrapperRepeatableParticleHandler
implements RepeatableParticleHandler {
    protected static final Logger log = Logger.getLogger(ArrayWrapperRepeatableParticleHandler.class);
    protected boolean trace = log.isTraceEnabled();
    private final AbstractPropertyHandler setParentProperty;

    public ArrayWrapperRepeatableParticleHandler(AbstractPropertyHandler setParentProperty) {
        if (setParentProperty == null) {
            throw new IllegalArgumentException("setParentProperty is null");
        }
        this.setParentProperty = setParentProperty;
    }

    @Override
    public void addTermValue(Object particleValue, Object termValue, QName elementName, ParticleBinding particle, ParticleBinding parentParticle, ParticleHandler handler) {
        ((List)particleValue).add(termValue);
        if (this.trace) {
            log.trace((Object)("added " + elementName + " " + termValue));
        }
    }

    @Override
    public void endRepeatableParticle(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        ValueAdapter valueAdapter;
        if (this.trace) {
            log.trace((Object)("endRepeatableParticle " + elementName));
        }
        if ((valueAdapter = particle.getTerm().getValueAdapter()) != null) {
            o = valueAdapter.cast(o, null);
        }
        o = this.toArray((List)o, (ArrayInfo)this.setParentProperty.getPropertyType());
        this.setParentProperty.doHandle(parent, o, elementName);
    }

    @Override
    public Object startRepeatableParticle(Object parent, QName startName, ParticleBinding particle) {
        if (this.trace) {
            log.trace((Object)("startRepeatableParticle " + startName));
        }
        return new ArrayList();
    }

    private Object[] toArray(List<Object> elements, ArrayInfo arrayInfo) {
        try {
            Object[] arr = (Object[])arrayInfo.newArrayInstance(elements.size());
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = elements.get(i);
            }
            return arr;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating array of type " + arrayInfo.getName() + " from " + elements, t);
        }
    }
}

