/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.component.interceptors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ejb.ObjectNotFoundException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.component.CmpEntityBeanComponentInstance;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeFinderInterceptorFactory;
import org.jboss.invocation.InterceptorContext;

public class CmpEntityBeanHomeFinderInterceptorFactory
extends EntityBeanHomeFinderInterceptorFactory {
    private final Method finderMethod;
    private final boolean localHome;

    public CmpEntityBeanHomeFinderInterceptorFactory(Method finderMethod, boolean localHome) {
        super(finderMethod);
        this.finderMethod = finderMethod;
        this.localHome = localHome;
    }

    protected Object invokeFind(InterceptorContext context, EntityBeanComponentInstance instance) throws Exception {
        CmpEntityBeanComponentInstance cmpInstance = (CmpEntityBeanComponentInstance)((Object)CmpEntityBeanComponentInstance.class.cast(instance));
        final CmpEntityBeanComponent cmpComponent = cmpInstance.getComponent();
        try {
            cmpComponent.getComponentClass().getDeclaredMethod(this.finderMethod.getName(), this.finderMethod.getParameterTypes());
            return super.invokeFind(context, instance);
        }
        catch (NoSuchMethodException ignored) {
            JDBCEntityPersistenceStore store = cmpComponent.getStoreManager();
            CmpEntityBeanContext entityContext = cmpInstance.getEjbContext();
            if (this.finderMethod.getName().equals("findByPrimaryKey")) {
                if (this.finderMethod.getParameterTypes() == null || this.finderMethod.getParameterTypes().length != 1) {
                    throw CmpMessages.MESSAGES.illegalNumberOfArgumentsForFindByPrimaryKey(this.finderMethod.getParameterTypes() == null ? 0 : this.finderMethod.getParameterTypes().length);
                }
                if (context.getParameters()[0] == null) {
                    throw CmpMessages.MESSAGES.nullArgumentForFindByPrimaryKey();
                }
                ReadyEntityCache cache = cmpComponent.getCache();
                if (cache.containsNotRemoved(context.getParameters()[0])) {
                    return this.localHome ? cmpComponent.getEJBLocalObject(context.getParameters()[0]) : cmpComponent.getEJBObject(context.getParameters()[0]);
                }
            } else if (!store.getCmpConfig().isSyncOnCommitOnly()) {
                cmpComponent.synchronizeEntitiesWithinTransaction(entityContext.getTransaction());
            }
            JDBCQueryCommand.EntityProxyFactory factory = new JDBCQueryCommand.EntityProxyFactory(){

                @Override
                public Object getEntityObject(Object primaryKey) {
                    return CmpEntityBeanHomeFinderInterceptorFactory.this.localHome ? cmpComponent.getEJBLocalObject(primaryKey) : cmpComponent.getEJBObject(primaryKey);
                }
            };
            if (this.getReturnType() == EntityBeanHomeFinderInterceptorFactory.ReturnType.SINGLE) {
                return store.findEntity(context.getMethod(), context.getParameters(), entityContext, factory);
            }
            return store.findEntities(context.getMethod(), context.getParameters(), entityContext, factory);
        }
    }

    protected Object prepareResults(InterceptorContext context, Object result, EntityBeanComponent component) throws ObjectNotFoundException {
        switch (this.getReturnType()) {
            case COLLECTION: {
                return result;
            }
            case ENUMERATION: {
                Collection entities = (Collection)result;
                final Iterator iterator = entities.iterator();
                return new Enumeration<Object>(){

                    @Override
                    public boolean hasMoreElements() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Object nextElement() {
                        return iterator.next();
                    }
                };
            }
        }
        return result;
    }
}

