/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.ejbql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.CMRFieldBridge;
import org.jboss.as.cmp.bridge.EntityBridge;
import org.jboss.as.cmp.ejbql.Catalog;

public final class IdentifierManager {
    private final Catalog catalog;
    private final Map pathLists = new HashMap();
    private final Map fieldLists = new HashMap();
    private final Map identifiers = new HashMap();

    public IdentifierManager(Catalog catalog) {
        this.catalog = catalog;
    }

    public void declareRangeVariable(String identifier, String abstractSchemaName) {
        this.identifiers.put(identifier, this.catalog.getEntityByAbstractSchemaName(abstractSchemaName));
    }

    public void declareCollectionMember(String identifier, String path) {
        List fieldList = (List)this.fieldLists.get(path);
        Object field = fieldList.get(fieldList.size() - 1);
        if (!(field instanceof CMRFieldBridge)) {
            throw CmpMessages.MESSAGES.pathIsCollectionValued(path);
        }
        CMRFieldBridge cmrField = (CMRFieldBridge)field;
        if (cmrField.isSingleValued()) {
            throw CmpMessages.MESSAGES.pathIsCollectionValued(path);
        }
        this.identifiers.put(identifier, cmrField.getRelatedEntity());
    }

    public EntityBridge getEntity(String identificationVariable) {
        return (EntityBridge)this.identifiers.get(identificationVariable);
    }

    public void registerPath(String path, List pathList, List fieldList) {
        if (pathList.size() != fieldList.size()) {
            throw CmpMessages.MESSAGES.pathAndFieldListMustBeSameSize(pathList.size(), fieldList.size());
        }
        this.pathLists.put(path, pathList);
        this.fieldLists.put(path, fieldList);
    }

    public List getPathList(String path) {
        return (List)this.pathLists.get(path);
    }

    public List getFieldList(String path) {
        return (List)this.fieldLists.get(path);
    }
}

