/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class JdbcStoreManagerInitService
implements Service<JDBCStoreManager> {
    private final JDBCStoreManager storeManager;
    private final ClassLoader classLoader;

    public JdbcStoreManagerInitService(JDBCStoreManager storeManager, ClassLoader classLoader) {
        this.storeManager = storeManager;
        this.classLoader = classLoader;
    }

    public synchronized void start(StartContext context) throws StartException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.storeManager.initStoreManager();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToStartJdbcStore(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.storeManager.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized JDBCStoreManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.storeManager;
    }
}

