/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCOracleSequenceCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence_name;
    private int pkIndex;
    private int jdbcType;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.sequence_name = entityCommand.getAttribute("sequence_name");
        if (this.sequence_name == null) {
            throw CmpMessages.MESSAGES.sequenceNameRequired();
        }
    }

    @Override
    protected void initInsertSQL() {
        this.pkIndex = 1 + this.insertFields.length;
        this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
        StringBuffer sql = new StringBuffer();
        sql.append("{call INSERT INTO ").append(this.entity.getTableName());
        sql.append(" (");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" VALUES (");
        String sequence_name_inst = JDBCOracleSequenceCreateCommand.replaceTable(this.sequence_name, this.entity.getTableName());
        sql.append(sequence_name_inst + ".NEXTVAL, ");
        SQLUtil.getValuesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" RETURNING ");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug((Object)("Insert Entity SQL: " + this.insertSQL));
        }
    }

    @Override
    protected PreparedStatement prepareStatement(Connection c, String sql, CmpEntityBeanContext ctx) throws SQLException {
        return c.prepareCall(sql);
    }

    @Override
    protected int executeInsert(int paramInd, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        CallableStatement cs = (CallableStatement)ps;
        cs.registerOutParameter(this.pkIndex, this.jdbcType);
        cs.execute();
        Object pk = JDBCUtil.getParameter(this.log, cs, this.pkIndex, this.jdbcType, this.pkField.getFieldType());
        this.pkField.setInstanceValue(ctx, pk);
        return 1;
    }

    private static String replaceTable(String in, String table) {
        int pos = in.indexOf("%%t");
        if (pos == -1) {
            return in;
        }
        String first = in.substring(0, pos);
        String last = in.substring(pos + 3);
        return first + table + last;
    }
}

