/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCDynamicQLQueryMetaData
implements JDBCQueryMetaData {
    private final Method method;
    private final boolean resultTypeMappingLocal;
    private final JDBCReadAheadMetaData readAhead;
    private final Class<?> compiler;
    private final boolean lazyResultSetLoading;

    public JDBCDynamicQLQueryMetaData(JDBCDynamicQLQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class<?> qlCompiler, boolean lazyResultSetLoading) {
        this.method = defaults.getMethod();
        this.readAhead = readAhead;
        this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
        this.compiler = qlCompiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCDynamicQLQueryMetaData(boolean resultTypeMappingLocal, Method method, JDBCReadAheadMetaData readAhead, Class<?> compiler, boolean lazyResultSetLoading) {
        this.method = method;
        this.readAhead = readAhead;
        this.resultTypeMappingLocal = resultTypeMappingLocal;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2 || !parameterTypes[0].equals(String.class) || !parameterTypes[1].equals(Object[].class)) {
            throw CmpMessages.MESSAGES.dynamicQlInvalidParameters();
        }
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isResultTypeMappingLocal() {
        return this.resultTypeMappingLocal;
    }

    @Override
    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Class getQLCompilerClass() {
        return this.compiler;
    }

    @Override
    public boolean isLazyResultSetLoading() {
        return this.lazyResultSetLoading;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCDynamicQLQueryMetaData) {
            return ((JDBCDynamicQLQueryMetaData)o).method.equals(this.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "[JDBCDynamicQLQueryMetaData : method=" + this.method + "]";
    }
}

