/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.ejb.CreateException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc2.CreateCommand;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.PersistentContext;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;

public class ApplicationPkCreateCommand
implements CreateCommand {
    private JDBCEntityBridge2 entityBridge;

    @Override
    public void init(JDBCStoreManager2 manager) {
        this.entityBridge = (JDBCEntityBridge2)manager.getEntityBridge();
    }

    @Override
    public Object execute(Method m, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        Object pk;
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        if (ctx.getPrimaryKeyUnchecked() == null) {
            pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
            if (pk == null) {
                throw CmpMessages.MESSAGES.pkIsNullForCreatedInstance();
            }
            pctx.setPk(pk);
        } else {
            try {
                pctx.flush();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    throw CmpMessages.MESSAGES.uniqueKeyViolation(ctx.getPrimaryKeyUnchecked());
                }
                throw CmpMessages.MESSAGES.failedToCreateInstance(ctx.getPrimaryKeyUnchecked(), e);
            }
            pk = ctx.getPrimaryKeyUnchecked();
        }
        return pk;
    }
}

