/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.sts.token.validator.SAMLRoleParser;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.ws.security.saml.ext.AssertionWrapper;

public class DefaultSAMLRoleParser
implements SAMLRoleParser {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    private boolean useJaasSubject = true;
    private String roleClassifier;
    private String roleClassifierType = "prefix";
    private String roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";

    @Override
    public Set<Principal> parseRolesFromAssertion(Principal principal, Subject subject, AssertionWrapper assertion) {
        if (subject != null && this.useJaasSubject) {
            if (this.roleClassifier != null && !"".equals(this.roleClassifier)) {
                RolePrefixSecurityContextImpl securityContext = new RolePrefixSecurityContextImpl(subject, this.roleClassifier, this.roleClassifierType);
                return securityContext.getUserRoles();
            }
            return new DefaultSecurityContext(principal, subject).getUserRoles();
        }
        List roles = SAMLUtils.parseRolesInAssertion((Object)assertion, (String)this.roleAttributeName);
        SAMLSecurityContext context = this.createSecurityContext(principal, roles);
        return context.getUserRoles();
    }

    private SAMLSecurityContext createSecurityContext(Principal p, List<String> roles) {
        HashSet<SimplePrincipal> userRoles;
        if (roles != null) {
            userRoles = new HashSet<SimplePrincipal>();
            for (String role : roles) {
                userRoles.add(new SimplePrincipal(role));
            }
        } else {
            userRoles = null;
        }
        return new SAMLSecurityContext(p, userRoles);
    }

    public boolean isUseJaasSubject() {
        return this.useJaasSubject;
    }

    public void setUseJaasSubject(boolean useJaasSubject) {
        this.useJaasSubject = useJaasSubject;
    }

    public String getRoleClassifier() {
        return this.roleClassifier;
    }

    public void setRoleClassifier(String roleClassifier) {
        this.roleClassifier = roleClassifier;
    }

    public String getRoleClassifierType() {
        return this.roleClassifierType;
    }

    public void setRoleClassifierType(String roleClassifierType) {
        this.roleClassifierType = roleClassifierType;
    }

    public String getRoleAttributeName() {
        return this.roleAttributeName;
    }

    public void setRoleAttributeName(String roleAttributeName) {
        this.roleAttributeName = roleAttributeName;
    }
}

