/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractWriteAttributeHandler<T>
implements OperationStepHandler {
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final ParameterValidator unresolvedValueValidator;
    private final ParameterValidator resolvedValueValidator;
    private final Map<String, AttributeDefinition> attributeDefinitions;

    @Deprecated
    protected AbstractWriteAttributeHandler() {
        this((ParameterValidator)null, (ParameterValidator)null);
    }

    @Deprecated
    protected AbstractWriteAttributeHandler(ParameterValidator validator) {
        this(validator, validator);
    }

    protected AbstractWriteAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
        this.unresolvedValueValidator = null;
        this.resolvedValueValidator = null;
    }

    protected AbstractWriteAttributeHandler(Collection<AttributeDefinition> definitions) {
        this(definitions.toArray(new AttributeDefinition[definitions.size()]));
    }

    @Deprecated
    protected AbstractWriteAttributeHandler(ParameterValidator unresolvedValidator, ParameterValidator resolvedValidator) {
        this.nameValidator.registerValidator("name", new StringLengthValidator(1));
        this.unresolvedValueValidator = unresolvedValidator;
        this.resolvedValueValidator = resolvedValidator;
        this.attributeDefinitions = null;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode defaultValue;
        this.nameValidator.validate(operation);
        final String attributeName = operation.require("name").asString();
        ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        this.validateUnresolvedValue(attributeName, newValue);
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode submodel = resource.getModel();
        final ModelNode currentValue = submodel.get(attributeName).clone();
        final AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        if (attributeDefinition != null) {
            defaultValue = attributeDefinition.getDefaultValue();
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            attributeDefinition.validateAndSet(syntheticOp, submodel);
            newValue = submodel.get(attributeName);
        } else {
            defaultValue = null;
            submodel.get(attributeName).set(newValue);
        }
        this.finishModelStage(context, operation, attributeName, newValue, currentValue, resource);
        if (this.requiresRuntime(context)) {
            final ModelNode updatedValue = newValue;
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ModelNode resolvedValue = attributeDefinition != null ? attributeDefinition.resolveModelAttribute(context, submodel) : updatedValue.resolve();
                    AbstractWriteAttributeHandler.this.validateResolvedValue(attributeName, updatedValue);
                    final HandbackHolder handback = new HandbackHolder();
                    final boolean reloadRequired = AbstractWriteAttributeHandler.this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback);
                    if (reloadRequired) {
                        if (attributeDefinition != null && attributeDefinition.getFlags().contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                            context.restartRequired();
                        } else {
                            context.reloadRequired();
                        }
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            ModelNode valueToRestore = currentValue.resolve();
                            if (!valueToRestore.isDefined() && defaultValue != null) {
                                valueToRestore = defaultValue;
                            }
                            try {
                                AbstractWriteAttributeHandler.this.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, handback.handback);
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress(operation.get("address")));
                            }
                            if (reloadRequired) {
                                if (attributeDefinition != null && attributeDefinition.getFlags().contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                                    context.revertRestartRequired();
                                } else {
                                    context.revertReloadRequired();
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    protected abstract boolean applyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, HandbackHolder<T> var6) throws OperationFailedException;

    protected abstract void revertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, T var6) throws OperationFailedException;

    @Deprecated
    protected void validateUnresolvedValue(String attributeName, ModelNode unresolvedValue) throws OperationFailedException {
        if (this.unresolvedValueValidator != null) {
            this.unresolvedValueValidator.validateParameter("value", unresolvedValue);
        }
    }

    @Deprecated
    protected void validateResolvedValue(String attributeName, ModelNode resolvedValue) throws OperationFailedException {
        if (this.resolvedValueValidator != null) {
            this.resolvedValueValidator.validateResolvedParameter("value", resolvedValue);
        }
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        this.validateUpdatedModel(context, model);
    }

    protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer() && !context.isBooting();
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }

    public static class HandbackHolder<T> {
        private T handback;

        public void setHandback(T handback) {
            this.handback = handback;
        }
    }
}

