/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AuthorizedAddress;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BootErrorCollector {
    private final ModelNode errors = new ModelNode();
    private final OperationStepHandler listBootErrorsHandler;

    public BootErrorCollector() {
        this.errors.setEmptyList();
        this.listBootErrorsHandler = new ListBootErrorsHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailureDescription(ModelNode operation, ModelNode failureDescription) {
        assert (operation != null);
        assert (failureDescription != null);
        ModelNode error = new ModelNode();
        ModelNode failedOperation = error.get("failed-operation");
        failedOperation.get("operation").set(operation.get("operation"));
        error.get("failure-timestamp").set(System.currentTimeMillis());
        ModelNode opAddr = operation.get("address");
        if (!opAddr.isDefined()) {
            opAddr.setEmptyList();
        }
        failedOperation.get("address").set(opAddr);
        error.get("failure-description").set(failureDescription.asString());
        ModelNode report = ServiceVerificationHandler.extractFailedServicesDescription(failureDescription);
        if (report != null) {
            error.get("failed-services").set(report);
        }
        if ((report = ServiceVerificationHandler.extractMissingServicesDescription(failureDescription)) != null) {
            error.get("services-missing-dependencies").set(report);
        }
        if ((report = ServiceVerificationHandler.extractTransitiveDependencyProblemDescription(failureDescription)) != null) {
            error.get("missing-transitive-dependency-problems").set(report);
        }
        ModelNode modelNode = this.errors;
        synchronized (modelNode) {
            this.errors.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode getErrors() {
        ModelNode modelNode = this.errors;
        synchronized (modelNode) {
            return this.errors.clone();
        }
    }

    public OperationStepHandler getReadBootErrorsHandler() {
        return this.listBootErrorsHandler;
    }

    public static class ListBootErrorsHandler
    implements OperationStepHandler {
        public static final String OPERATION_NAME = "read-boot-errors";
        private final BootErrorCollector errors;
        private static final AttributeDefinition OP_DEFINITION = ObjectTypeAttributeDefinition.Builder.of("failed-operation", SimpleAttributeDefinitionBuilder.create("operation", ModelType.STRING, false).build(), SimpleAttributeDefinitionBuilder.create("failure-timestamp", ModelType.LONG, false).build(), SimpleListAttributeDefinition.Builder.of("address", SimpleAttributeDefinitionBuilder.create("element", ModelType.PROPERTY, false).build()).build()).setAllowNull(false).build();
        private static final AttributeDefinition FAILURE_MESSAGE = SimpleAttributeDefinitionBuilder.create("failure-description", ModelType.STRING, false).build();
        private static final AttributeDefinition FAILED_SVC_AD = SimpleListAttributeDefinition.Builder.of("failed-services", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).setAllowNull(true).build();
        private static final AttributeDefinition MISSING_DEPS_AD = SimpleListAttributeDefinition.Builder.of("services-missing-dependencies", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).setAllowNull(true).build();
        private static final AttributeDefinition AFFECTED_AD = SimpleListAttributeDefinition.Builder.of("services-missing-transitive-dependencies", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).build();
        private static final AttributeDefinition CAUSE_AD = SimpleListAttributeDefinition.Builder.of("possible-causes", SimpleAttributeDefinitionBuilder.create("element", ModelType.STRING, false).build()).build();
        private static final AttributeDefinition TRANSITIVE_AD = ObjectTypeAttributeDefinition.Builder.of("missing-transitive-dependency-problems", AFFECTED_AD, CAUSE_AD).setAllowNull(true).build();
        public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-boot-errors", ControllerResolver.getResolver("errors")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyParameters(OP_DEFINITION, FAILURE_MESSAGE, FAILED_SVC_AD, MISSING_DEPS_AD, TRANSITIVE_AD).build();

        ListBootErrorsHandler(BootErrorCollector errors) {
            this.errors = errors;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode bootErrors = new ModelNode().setEmptyList();
                    ModelNode errorsNode = ListBootErrorsHandler.this.errors.getErrors();
                    for (ModelNode bootError : errorsNode.asList()) {
                        ListBootErrorsHandler.this.secureOperationAddress(context, bootError);
                        bootErrors.add(bootError);
                    }
                    context.getResult().set(bootErrors);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }

        private void secureOperationAddress(OperationContext context, ModelNode bootError) throws OperationFailedException {
            if (bootError.hasDefined("failed-operation")) {
                ModelNode failedOperation = bootError.get("failed-operation");
                ModelNode address = failedOperation.get("address");
                ModelNode fakeOperation = new ModelNode();
                fakeOperation.get("operation").set("read-resource");
                fakeOperation.get("address").set(address);
                AuthorizedAddress authorizedAddress = AuthorizedAddress.authorizeAddress(context, fakeOperation);
                if (authorizedAddress.isElided()) {
                    failedOperation.get("address").set(authorizedAddress.getAddress());
                }
            }
        }
    }
}

