/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Stack;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;

public class ExpressionResolverImpl
implements ExpressionResolver {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private final boolean lenient = false;

    protected ExpressionResolverImpl() {
    }

    @Override
    public final ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.resolveExpressionsRecursively(node);
    }

    private ModelNode resolveExpressionsRecursively(ModelNode node) throws OperationFailedException {
        ModelNode resolved;
        if (!node.isDefined()) {
            return node;
        }
        ModelType type = node.getType();
        if (type == ModelType.EXPRESSION) {
            resolved = this.resolveExpressionStringRecursively(node.asExpression().getExpressionString(), false, true);
        } else if (type == ModelType.OBJECT) {
            resolved = node.clone();
            for (Property prop : resolved.asPropertyList()) {
                resolved.get(prop.getName()).set(this.resolveExpressionsRecursively(prop.getValue()));
            }
        } else if (type == ModelType.LIST) {
            resolved = node.clone();
            ModelNode list = new ModelNode();
            for (ModelNode current : resolved.asList()) {
                list.add(this.resolveExpressionsRecursively(current));
            }
            resolved = list;
        } else if (type == ModelType.PROPERTY) {
            resolved = node.clone();
            resolved.set(resolved.asProperty().getName(), this.resolveExpressionsRecursively(resolved.asProperty().getValue()));
        } else {
            resolved = node;
        }
        return resolved;
    }

    protected void resolvePluggableExpression(ModelNode node) throws OperationFailedException {
    }

    private ModelNode resolveExpressionStringRecursively(String expressionString, boolean ignoreDMRResolutionFailure, boolean initial) throws OperationFailedException {
        ParseAndResolveResult resolved = this.parseAndResolve(expressionString, ignoreDMRResolutionFailure);
        if (resolved.recursive) {
            return this.resolveExpressionStringRecursively(resolved.result, true, false);
        }
        if (resolved.modified) {
            return new ModelNode(resolved.result);
        }
        if (initial && EXPRESSION_PATTERN.matcher(expressionString).matches()) {
            assert (ignoreDMRResolutionFailure);
            return new ModelNode(new ValueExpression(expressionString));
        }
        return new ModelNode(expressionString);
    }

    private ParseAndResolveResult parseAndResolve(String initialValue, boolean lenient) throws OperationFailedException {
        StringBuilder builder = new StringBuilder();
        int len = initialValue.length();
        int state = 0;
        int ignoreBraceLevel = 0;
        boolean modified = false;
        Stack<OpenExpression> stack = null;
        int i = 0;
        while (i < len) {
            int ch = initialValue.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            stack = ExpressionResolverImpl.addToStack(stack, i);
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 123: {
                            state = 2;
                            break block0;
                        }
                    }
                    if (stack.size() == 1) {
                        stack.clear();
                        if (ch != 36) {
                            builder.append('$');
                        } else {
                            modified = true;
                        }
                        builder.appendCodePoint(ch);
                        state = 0;
                        break;
                    }
                    stack.pop();
                    state = 2;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 36: {
                            stack.push(new OpenExpression(i));
                            state = 1;
                            break block0;
                        }
                        case 123: {
                            ++ignoreBraceLevel;
                            break block0;
                        }
                        case 125: {
                            String resolved;
                            if (ignoreBraceLevel > 0) {
                                --ignoreBraceLevel;
                                break block0;
                            }
                            String toResolve = ExpressionResolverImpl.getStringToResolve(initialValue, stack, i);
                            if (!toResolve.equals(resolved = this.resolveExpressionString(toResolve))) {
                                if (EXPRESSION_PATTERN.matcher(resolved).matches()) {
                                    return ExpressionResolverImpl.createRecursiveResult(initialValue, resolved, stack, i);
                                }
                                ExpressionResolverImpl.recordResolutionInStack(resolved, stack);
                                if (stack.size() == 0) {
                                    builder.append(resolved);
                                    state = 0;
                                } else {
                                    state = 2;
                                }
                                modified = true;
                                break block0;
                            }
                            if (stack.size() > 1) {
                                ExpressionResolverImpl.recordResolutionInStack(toResolve, stack);
                                state = 2;
                                break block0;
                            }
                            if (lenient) {
                                return new ParseAndResolveResult(initialValue, false, false);
                            }
                            throw ControllerMessages.MESSAGES.cannotResolveExpression(initialValue);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            i = initialValue.offsetByCodePoints(i, 1);
        }
        if (stack != null && stack.size() > 0) {
            if (state == 1) {
                stack.pop();
            }
            if (stack.size() > 0) {
                throw ControllerMessages.MESSAGES.incompleteExpression(initialValue);
            }
            builder.append('$');
        }
        return new ParseAndResolveResult(builder.toString(), modified, false);
    }

    private static Stack<OpenExpression> addToStack(Stack<OpenExpression> stack, int startIndex) {
        Stack<OpenExpression> result = stack == null ? new Stack<OpenExpression>() : stack;
        result.push(new OpenExpression(startIndex));
        return result;
    }

    private String resolveExpressionString(String unresolvedString) throws OperationFailedException {
        assert (unresolvedString.startsWith("${") && unresolvedString.endsWith("}"));
        String result = unresolvedString;
        ModelNode resolveNode = new ModelNode(new ValueExpression(unresolvedString));
        this.resolvePluggableExpression(resolveNode);
        if (resolveNode.getType() == ModelType.EXPRESSION) {
            String resolvedString = ExpressionResolverImpl.resolveStandardExpression(resolveNode);
            if (!unresolvedString.equals(resolvedString)) {
                result = resolvedString;
            }
        } else {
            result = resolveNode.asString();
        }
        return result;
    }

    private static String resolveStandardExpression(ModelNode unresolved) throws OperationFailedException {
        try {
            return unresolved.resolve().asString();
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode(ControllerMessages.MESSAGES.noPermissionToResolveExpression(unresolved, e)));
        }
        catch (IllegalStateException e) {
            return unresolved.asString();
        }
    }

    private static String getStringToResolve(String initialValue, Stack<OpenExpression> stack, int expressionEndIndex) {
        int stackSize = stack.size();
        int expressionElement = -1;
        OpenExpression firstUnresolved = null;
        for (int i = stackSize - 1; i >= 0; --i) {
            OpenExpression oe = (OpenExpression)stack.get(i);
            if (oe.resolvedValue != null) continue;
            expressionElement = i;
            firstUnresolved = oe;
            break;
        }
        assert (expressionElement > -1);
        firstUnresolved.endIndex = expressionEndIndex;
        if (expressionElement == stackSize - 1) {
            return initialValue.substring(firstUnresolved.startIndex, expressionEndIndex + 1);
        }
        StringBuilder sb = new StringBuilder();
        int nextStart = firstUnresolved.startIndex;
        for (int i = expressionElement + 1; i < stackSize; ++i) {
            OpenExpression oe = (OpenExpression)stack.get(i);
            sb.append(initialValue.substring(nextStart, oe.startIndex));
            sb.append(oe.resolvedValue);
            nextStart = oe.endIndex + 1;
        }
        sb.append(initialValue.substring(nextStart, expressionEndIndex + 1));
        return sb.toString();
    }

    private static ParseAndResolveResult createRecursiveResult(String initialValue, String val, Stack<OpenExpression> stack, int expressionEndIndex) {
        String result;
        int initialLength = initialValue.length();
        int expressionIndex = -1;
        while (expressionIndex == -1) {
            OpenExpression oe = stack.pop();
            if (oe.resolvedValue != null) continue;
            expressionIndex = oe.startIndex;
        }
        if (expressionIndex == 0 && expressionEndIndex == initialLength - 1) {
            result = val;
        } else if (expressionIndex == 0) {
            result = val + initialValue.substring(expressionEndIndex + 1);
        } else {
            StringBuilder sb = new StringBuilder(initialValue.substring(0, expressionIndex));
            sb.append(val);
            if (expressionEndIndex < initialLength - 1) {
                sb.append(initialValue.substring(expressionEndIndex + 1));
            }
            result = sb.toString();
        }
        return new ParseAndResolveResult(result, true, true);
    }

    private static void recordResolutionInStack(String val, Stack<OpenExpression> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            OpenExpression oe;
            OpenExpression openExpression = oe = i == 0 ? stack.pop() : stack.peek();
            if (oe.resolvedValue == null) {
                oe.resolvedValue = val;
                break;
            }
            assert (i > 0);
            stack.pop();
        }
    }

    private static class OpenExpression {
        private final int startIndex;
        private int endIndex = -1;
        private String resolvedValue;

        private OpenExpression(int startIndex) {
            this.startIndex = startIndex;
        }
    }

    private static class ParseAndResolveResult {
        private final String result;
        private final boolean modified;
        private final boolean recursive;

        private ParseAndResolveResult(String result, boolean modified, boolean recursive) {
            this.result = result;
            this.modified = modified;
            this.recursive = recursive;
        }
    }
}

