/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.GetAccessControlContextAction;
import org.jboss.as.controller.HostServerGroupTracker;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerLock;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReadOnlyContext;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.ParallelExtensionAddHandler;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;

class ModelControllerImpl
implements ModelController {
    private static final String INITIAL_BOOT_OPERATION = "initial-boot-operation";
    private static final String POST_EXTENSION_BOOT_OPERATION = "post-extension-boot-operation";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ManagementResourceRegistration rootRegistration;
    private final ModelControllerLock controllerLock = new ModelControllerLock();
    private final ContainerStateMonitor stateMonitor;
    private final RootResource model = new RootResource();
    private final ConfigurationPersister persister;
    private final ProcessType processType;
    private final RunningModeControl runningModeControl;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    private final ExecutorService executorService;
    private final ExpressionResolver expressionResolver;
    private final Authorizer authorizer;
    private final ConcurrentMap<Integer, OperationContextImpl> activeOperations = new ConcurrentHashMap<Integer, OperationContextImpl>();
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final NotificationSupport notificationSupport;
    private final HostServerGroupTracker hostServerGroupTracker;
    private final Resource.ResourceEntry modelControllerResource;

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, ProcessType processType, RunningModeControl runningModeControl, OperationStepHandler prepareStep, ControlledProcessState processState, ExecutorService executorService, ExpressionResolver expressionResolver, Authorizer authorizer, ManagedAuditLogger auditLogger, NotificationSupport notificationSupport, BootErrorCollector bootErrorCollector) {
        assert (serviceRegistry != null);
        this.serviceRegistry = serviceRegistry;
        assert (serviceTarget != null);
        this.serviceTarget = serviceTarget;
        assert (rootRegistration != null);
        this.rootRegistration = rootRegistration;
        assert (stateMonitor != null);
        this.stateMonitor = stateMonitor;
        assert (persister != null);
        this.persister = persister;
        assert (processType != null);
        this.processType = processType;
        assert (runningModeControl != null);
        this.runningModeControl = runningModeControl;
        assert (notificationSupport != null);
        this.notificationSupport = notificationSupport;
        OperationStepHandler operationStepHandler = this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        assert (processState != null);
        this.processState = processState;
        this.serviceTarget.addListener((ServiceListener)stateMonitor);
        this.executorService = executorService;
        assert (expressionResolver != null);
        this.expressionResolver = expressionResolver;
        assert (authorizer != null);
        this.authorizer = authorizer;
        assert (auditLogger != null);
        this.auditLogger = auditLogger;
        assert (bootErrorCollector != null);
        this.bootErrorCollector = bootErrorCollector;
        this.hostServerGroupTracker = processType.isManagedDomain() ? new HostServerGroupTracker() : null;
        this.modelControllerResource = new ModelControllerResource();
        auditLogger.startBoot();
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        OperationResponse or = this.internalExecute(operation, handler, control, attachments, this.prepareStep);
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing response to %s whose associated streams, if any, were not wanted", operation);
        }
        return result;
    }

    @Override
    public OperationResponse execute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control) {
        return this.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, this.prepareStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int operationId) {
        AbstractOperationContext delegateContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((delegateContext = (AbstractOperationContext)this.activeOperations.get(operationId)) == null) {
            throw new IllegalStateException("no context to delegate with id: " + operationId);
        }
        final ModelNode response = new ModelNode();
        ModelController.OperationTransactionControl originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, response);
            }
        };
        ReadOnlyContext context = new ReadOnlyContext(this.processType, this.runningModeControl.getRunningMode(), originalResultTxControl, this.processState, false, delegateContext, this, operationId);
        context.addStep(response, operation, prepareStep, OperationContext.Stage.MODEL);
        CurrentOperationIdHolder.setCurrentOperationID(operationId);
        try {
            context.executeOperation();
        }
        finally {
            CurrentOperationIdHolder.setCurrentOperationID(null);
        }
        if (!response.hasDefined("response-headers") || !response.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    response.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OperationResponse internalExecute(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep) {
        Map<String, OperationResponse.StreamEntry> responseStreams;
        OperationContextImpl context;
        Integer operationID;
        boolean restartResourceServices;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        ModelNode headers = operation.has("operation-headers") ? operation.get("operation-headers") : null;
        boolean rollbackOnFailure = headers == null || !headers.hasDefined("rollback-on-runtime-failure") || headers.get("rollback-on-runtime-failure").asBoolean();
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        boolean bl = restartResourceServices = headers != null && headers.hasDefined("allow-resource-service-restart") && headers.get("allow-resource-service-restart").asBoolean();
        if (restartResourceServices) {
            contextFlags.add(AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
        }
        ModelNode blockingTimeoutConfig = headers != null && headers.hasDefined("blocking-timeout") ? headers.get("blocking-timeout") : null;
        final ModelNode responseNode = new ModelNode();
        ModelController.OperationTransactionControl originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, responseNode);
            }
        };
        AccessMechanism accessMechanism = null;
        AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
        if (accessContext != null) {
            if (operation.hasDefined("operation-headers")) {
                ModelNode operationHeaders = operation.get("operation-headers");
                if (operationHeaders.hasDefined("domain-uuid")) {
                    accessContext.setDomainUuid(operationHeaders.get("domain-uuid").asString());
                }
                if (operationHeaders.hasDefined("access-mechanism")) {
                    accessContext.setAccessMechanism(AccessMechanism.valueOf((String)operationHeaders.get("access-mechanism").asString()));
                }
            }
            accessMechanism = accessContext.getAccessMechanism();
        }
        if (accessMechanism != null && this.bootingFlag.get()) {
            return ModelControllerImpl.handleExternalRequestDuringBoot();
        }
        do {
            responseStreams = null;
        } while (this.activeOperations.putIfAbsent(operationID = Integer.valueOf(new Random(new SecureRandom().nextLong()).nextInt()), context = new OperationContextImpl(operationID, operation.get("operation").asString(), operation.get("address"), this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, attachments, this.model, originalResultTxControl, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, blockingTimeoutConfig, accessMechanism, this.notificationSupport)) != null);
        CurrentOperationIdHolder.setCurrentOperationID(operationID);
        try {
            context.addStep(responseNode, operation, prepareStep, OperationContext.Stage.MODEL);
            context.executeOperation();
            responseStreams = context.getResponseStreams();
        }
        catch (Throwable throwable) {
            if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                ControlledProcessState.State state = this.processState.getState();
                switch (state) {
                    case RELOAD_REQUIRED: 
                    case RESTART_REQUIRED: {
                        responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                        break;
                    }
                }
            }
            this.activeOperations.remove(operationID);
            CurrentOperationIdHolder.setCurrentOperationID(null);
            throw throwable;
        }
        if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        this.activeOperations.remove(operationID);
        CurrentOperationIdHolder.setCurrentOperationID(null);
        if (responseStreams != null && responseStreams.size() != 0) {
            return new OperationResponseImpl(responseNode, responseStreams);
        }
        return OperationResponse.Factory.createSimple((ModelNode)responseNode);
    }

    private static OperationResponse handleExternalRequestDuringBoot() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        result.get("failure-description").set(ControllerMessages.MESSAGES.managementUnavailableDuringBoot());
        return OperationResponse.Factory.createSimple((ModelNode)result);
    }

    boolean boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control, boolean rollbackOnRuntimeFailure) {
        OperationContext.ResultAction resultAction;
        Integer operationID = new Random(new SecureRandom().nextLong()).nextInt();
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnRuntimeFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        OperationContextImpl context = new OperationContextImpl(operationID, INITIAL_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.model, control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport);
        BootOperations bootOperations = this.organizeBootOperations(bootList, operationID);
        for (ParsedBootOp initialOp : bootOperations.initialOps) {
            context.addBootStep(initialOp);
        }
        if (bootOperations.invalid) {
            context.setRollbackOnly();
        }
        if ((resultAction = context.executeOperation()) == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
            OperationContextImpl postExtContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.model, control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport);
            for (ParsedBootOp parsedOp : bootOperations.postExtensionOps) {
                if (parsedOp.handler == null) {
                    parsedOp = new ParsedBootOp(parsedOp, this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName));
                }
                if (parsedOp.handler == null) {
                    this.logNoHandler(parsedOp);
                    postExtContext.setRollbackOnly();
                    break;
                }
                postExtContext.addBootStep(parsedOp);
            }
            resultAction = postExtContext.executeOperation();
        }
        return resultAction == OperationContext.ResultAction.KEEP;
    }

    private BootOperations organizeBootOperations(List<ModelNode> bootList, int lockPermit) {
        ArrayList<ParsedBootOp> initialOps = new ArrayList<ParsedBootOp>();
        ArrayList<ParsedBootOp> postExtensionOps = null;
        boolean invalid = false;
        boolean sawExtensionAdd = false;
        ParallelExtensionAddHandler parallelExtensionAddHandler = this.executorService == null ? null : new ParallelExtensionAddHandler(this.executorService);
        ParallelBootOperationStepHandler parallelSubsystemHandler = this.executorService != null && this.processType.isServer() && this.runningModeControl.getRunningMode() == RunningMode.NORMAL ? new ParallelBootOperationStepHandler(this.executorService, this.rootRegistration, this.processState, this, lockPermit) : null;
        boolean registeredParallelSubsystemHandler = false;
        int subsystemIndex = 0;
        for (ModelNode bootOp : bootList) {
            OperationStepHandler stepHandler;
            ParsedBootOp parsedOp = new ParsedBootOp(bootOp);
            if (postExtensionOps != null) {
                if (parsedOp.isExtensionAdd()) {
                    stepHandler = (ExtensionAddHandler)this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
                    if (parallelExtensionAddHandler != null) {
                        parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                        continue;
                    }
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                    continue;
                }
                if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                    if (registeredParallelSubsystemHandler && (parsedOp.isInterfaceOperation() || parsedOp.isSocketOperation())) {
                        postExtensionOps.add(subsystemIndex++, parsedOp);
                        continue;
                    }
                    postExtensionOps.add(parsedOp);
                    continue;
                }
                if (registeredParallelSubsystemHandler) continue;
                postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
                subsystemIndex = postExtensionOps.size() - 1;
                registeredParallelSubsystemHandler = true;
                continue;
            }
            stepHandler = this.rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
            if (!sawExtensionAdd && stepHandler == null) {
                this.logNoHandler(parsedOp);
                invalid = true;
                break;
            }
            if (stepHandler instanceof ExtensionAddHandler) {
                if (parallelExtensionAddHandler != null) {
                    parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                    if (!sawExtensionAdd) {
                        initialOps.add(parallelExtensionAddHandler.getParsedBootOp());
                    }
                } else {
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                }
                sawExtensionAdd = true;
                continue;
            }
            if (!sawExtensionAdd) {
                initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                continue;
            }
            postExtensionOps = new ArrayList<ParsedBootOp>(32);
            if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                postExtensionOps.add(parsedOp);
                continue;
            }
            postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
            registeredParallelSubsystemHandler = true;
        }
        return new BootOperations(initialOps, postExtensionOps, invalid);
    }

    void finishBoot() {
        this.auditLogger.bootDone();
        this.bootingFlag.set(false);
    }

    public Resource getRootResource() {
        return this.model;
    }

    public Resource.ResourceEntry getModelControllerResource() {
        return this.modelControllerResource;
    }

    ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    @Override
    public ModelControllerClient createClient(final Executor executor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        return new ModelControllerClient(){

            public void close() throws IOException {
            }

            public ModelNode execute(ModelNode operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(Operation operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, null);
            }

            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation.getOperation(), messageHandler, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation);
            }

            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT);
            }

            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation, messageHandler, null, ResponseConverter.TO_MODEL_NODE);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_MODEL_NODE);
            }

            public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_OPERATION_RESPONSE);
            }

            private <T> AsyncFuture<T> executeAsync(final ModelNode operation, final OperationMessageHandler messageHandler, final OperationAttachments attachments, ResponseConverter<T> responseConverter) {
                if (executor == null) {
                    throw ControllerMessages.MESSAGES.nullAsynchronousExecutor();
                }
                final AtomicReference opThread = new AtomicReference();
                class OpTask<T>
                extends AsyncFutureTask<T> {
                    private final ResponseConverter<T> responseConverter;

                    OpTask(ResponseConverter<T> responseConverter) {
                        super(var1_1.executor);
                        this.responseConverter = responseConverter;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void asyncCancel(boolean interruptionDesired) {
                        Thread thread = opThread.getAndSet(Thread.currentThread());
                        if (thread == null) {
                            this.setCancelled();
                        } else {
                            thread.interrupt();
                            boolean interrupted = false;
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                while (opThread.get() != null) {
                                    try {
                                        opThread.wait();
                                    }
                                    catch (InterruptedException ie) {
                                        interrupted = true;
                                    }
                                }
                            }
                            this.setCancelled();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }

                    void handleResult(OperationResponse result) {
                        ModelNode responseNode;
                        ModelNode modelNode = responseNode = result == null ? null : result.getResponseNode();
                        if (responseNode != null && responseNode.hasDefined("outcome") && "cancelled".equals(responseNode.get("outcome").asString())) {
                            this.setCancelled();
                        } else {
                            this.setResult(this.responseConverter.fromOperationResponse(result));
                        }
                    }
                }
                final OpTask opTask = new OpTask(responseConverter);
                final AccessControlContext acc = AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
                executor.execute(new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (opThread.compareAndSet(null, Thread.currentThread())) {
                                OperationResponse response = AccessController.doPrivileged(new PrivilegedAction<OperationResponse>(){

                                    @Override
                                    public OperationResponse run() {
                                        Operation op = attachments == null ? Operation.Factory.create((ModelNode)operation) : Operation.Factory.create((ModelNode)operation, (List)attachments.getInputStreams(), (boolean)attachments.isAutoCloseStreams());
                                        return ModelControllerImpl.this.execute(op, messageHandler, ModelController.OperationTransactionControl.COMMIT);
                                    }
                                }, acc);
                                opTask.handleResult(response);
                            }
                        }
                        finally {
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                opThread.set(null);
                                opThread.notifyAll();
                            }
                        }
                    }
                });
                return opTask;
            }
        };
    }

    ConfigurationPersister.PersistenceResource writeModel(final Resource resource, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        ModelNode newModel = Resource.Tools.readModel(resource);
        final ConfigurationPersister.PersistenceResource delegate = this.persister.store(newModel, affectedAddresses);
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                if (ModelControllerImpl.this.hostServerGroupTracker != null) {
                    ModelControllerImpl.this.hostServerGroupTracker.invalidate();
                }
                ModelControllerImpl.this.model.set(resource);
                delegate.commit();
            }

            @Override
            public void rollback() {
                delegate.rollback();
            }
        };
    }

    void acquireLock(Integer permit, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.controllerLock.lockInterruptibly(permit);
        } else {
            this.controllerLock.lock(permit);
        }
    }

    boolean acquireLock(Integer permit, boolean interruptibly, long timeout) throws InterruptedException {
        if (interruptibly) {
            return this.controllerLock.lockInterruptibly(permit, timeout, TimeUnit.SECONDS);
        }
        return this.controllerLock.lock(permit, timeout, TimeUnit.SECONDS);
    }

    void releaseLock(Integer permit) {
        this.controllerLock.unlock(permit);
    }

    void logContainerStateChangesAndReset() {
        this.stateMonitor.logContainerStateChangesAndReset();
    }

    void awaitContainerStability(long timeout, TimeUnit timeUnit, boolean interruptibly) throws InterruptedException, TimeoutException {
        if (interruptibly) {
            this.stateMonitor.awaitStability(timeout, timeUnit);
        } else {
            this.stateMonitor.awaitStabilityUninterruptibly(timeout, timeUnit);
        }
    }

    ContainerStateMonitor.ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.stateMonitor.awaitContainerStateChangeReport(timeout, timeUnit);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public NotificationHandlerRegistration getNotificationRegistry() {
        return this.notificationSupport.getNotificationRegistry();
    }

    NotificationSupport getNotificationSupport() {
        return this.notificationSupport;
    }

    ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.expressionResolver.resolveExpressions(node);
    }

    Authorizer getAuthorizer() {
        return this.authorizer;
    }

    private void logNoHandler(ParsedBootOp parsedOp) {
        ManagementResourceRegistration child = this.rootRegistration.getSubModel(parsedOp.address);
        if (child == null) {
            ControllerLogger.ROOT_LOGGER.noSuchResourceType(parsedOp.address);
        } else {
            ControllerLogger.ROOT_LOGGER.noHandlerForOperation(parsedOp.operationName, parsedOp.address);
        }
    }

    AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    void addFailureDescription(ModelNode operation, ModelNode failure) {
        if (this.bootingFlag.get()) {
            this.bootErrorCollector.addFailureDescription(operation, failure);
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }

    private static interface ResponseConverter<T> {
        public static final ResponseConverter<ModelNode> TO_MODEL_NODE = new ResponseConverter<ModelNode>(){

            @Override
            public ModelNode fromOperationResponse(OperationResponse or) {
                ModelNode result = or.getResponseNode();
                try {
                    or.close();
                }
                catch (IOException e) {
                    ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing %s whose associated streams, if any, were not wanted", or);
                }
                return result;
            }
        };
        public static final ResponseConverter<OperationResponse> TO_OPERATION_RESPONSE = new ResponseConverter<OperationResponse>(){

            @Override
            public OperationResponse fromOperationResponse(OperationResponse or) {
                return or;
            }
        };

        public T fromOperationResponse(OperationResponse var1);
    }

    private static class OperationResponseImpl
    implements OperationResponse {
        private final ModelNode simpleResponse;
        private final Map<String, OperationResponse.StreamEntry> inputStreams;

        private OperationResponseImpl(ModelNode simpleResponse, Map<String, OperationResponse.StreamEntry> inputStreams) {
            this.simpleResponse = simpleResponse;
            this.inputStreams = inputStreams;
            ModelNode header = simpleResponse.get(new String[]{"response-headers", "attached-streams"});
            header.setEmptyList();
            ArrayList streams = new ArrayList();
            for (OperationResponse.StreamEntry entry : inputStreams.values()) {
                ModelNode streamNode = new ModelNode();
                streamNode.get("uuid").set(entry.getUUID());
                streamNode.get("mime-type").set(entry.getMimeType());
                header.add(streamNode);
            }
        }

        public ModelNode getResponseNode() {
            return this.simpleResponse;
        }

        public List<OperationResponse.StreamEntry> getInputStreams() {
            return new ArrayList<OperationResponse.StreamEntry>(this.inputStreams.values());
        }

        public OperationResponse.StreamEntry getInputStream(String uuid) {
            return this.inputStreams.get(uuid);
        }

        public void close() throws IOException {
            int i = 0;
            for (OperationResponse.StreamEntry is : this.inputStreams.values()) {
                try {
                    is.getStream().close();
                }
                catch (Exception e) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf(e, "Failed closing response stream at index %d", i);
                }
                ++i;
            }
        }
    }

    private final class ModelControllerResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private ModelControllerResource() {
            super("service", "management-operations");
        }

        @Override
        public boolean hasChild(PathElement element) {
            try {
                return "active-operation".equals(element.getKey()) && ModelControllerImpl.this.activeOperations.containsKey(Integer.valueOf(element.getValue()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Resource getChild(PathElement element) {
            Resource.ResourceEntry result = null;
            if ("active-operation".equals(element.getKey())) {
                try {
                    OperationContextImpl context = (OperationContextImpl)ModelControllerImpl.this.activeOperations.get(Integer.valueOf(element.getValue()));
                    if (context != null) {
                        result = context.getActiveOperationResource();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public Resource requireChild(PathElement element) {
            Resource resource = this.getChild(element);
            if (resource == null) {
                throw new Resource.NoSuchResourceException(element);
            }
            return resource;
        }

        @Override
        public boolean hasChildren(String childType) {
            return "active-operation".equals(childType) && ModelControllerImpl.this.activeOperations.size() > 0;
        }

        @Override
        public Set<String> getChildTypes() {
            return Collections.singleton("active-operation");
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            HashSet<String> result = new HashSet<String>(ModelControllerImpl.this.activeOperations.size());
            for (Integer id : ModelControllerImpl.this.activeOperations.keySet()) {
                result.add(id.toString());
            }
            return result;
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>(ModelControllerImpl.this.activeOperations.size());
            for (OperationContextImpl context : ModelControllerImpl.this.activeOperations.values()) {
                result.add(context.getActiveOperationResource());
            }
            return result;
        }
    }

    private static final class BootOperations {
        private final List<ParsedBootOp> initialOps;
        private final List<ParsedBootOp> postExtensionOps;
        private final boolean invalid;

        private BootOperations(List<ParsedBootOp> initialOps, List<ParsedBootOp> postExtensionOps, boolean invalid) {
            this.initialOps = initialOps;
            this.postExtensionOps = postExtensionOps;
            this.invalid = invalid;
        }
    }

    private final class RootResource
    implements Resource {
        private final AtomicReference<Resource> modelReference = new AtomicReference<Resource>(Resource.Factory.create());

        private RootResource() {
        }

        void set(Resource resource) {
            this.modelReference.set(resource);
        }

        @Override
        public Resource clone() {
            return this.getDelegate().clone();
        }

        @Override
        public Resource getChild(PathElement element) {
            return this.getDelegate().getChild(element);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return this.getDelegate().getChildren(childType);
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.getDelegate().getChildrenNames(childType);
        }

        @Override
        public Set<String> getChildTypes() {
            return this.getDelegate().getChildTypes();
        }

        @Override
        public ModelNode getModel() {
            return this.getDelegate().getModel();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.getDelegate().hasChild(element);
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.getDelegate().hasChildren(childType);
        }

        @Override
        public boolean isModelDefined() {
            return this.getDelegate().isModelDefined();
        }

        @Override
        public boolean isProxy() {
            return this.getDelegate().isProxy();
        }

        @Override
        public boolean isRuntime() {
            return this.getDelegate().isRuntime();
        }

        @Override
        public Resource navigate(PathAddress address) {
            return this.getDelegate().navigate(address);
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            this.getDelegate().registerChild(address, resource);
        }

        @Override
        public Resource removeChild(PathElement address) {
            return this.getDelegate().removeChild(address);
        }

        @Override
        public Resource requireChild(PathElement element) {
            return this.getDelegate().requireChild(element);
        }

        @Override
        public void writeModel(ModelNode newModel) {
            this.getDelegate().writeModel(newModel);
        }

        private Resource getDelegate() {
            return this.modelReference.get();
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.trace("Executing " + operation.get("operation") + " " + operation.get("address"));
            }
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            String operationName = operation.require("operation").asString();
            OperationStepHandler stepHandler = ModelControllerImpl.this.rootRegistration.getOperationHandler(address, operationName);
            if (stepHandler != null) {
                context.addStep(stepHandler, OperationContext.Stage.MODEL);
            } else {
                ManagementResourceRegistration child = ModelControllerImpl.this.rootRegistration.getSubModel(address);
                if (child == null) {
                    context.getFailureDescription().set(ControllerMessages.MESSAGES.noSuchResourceType(address));
                } else {
                    context.getFailureDescription().set(ControllerMessages.MESSAGES.noHandlerForOperation(operationName, address));
                }
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

