/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public class StorageState {
    public static final String PROPERTY_BUNDLE_FILE = "BundleFile";
    public static final String PROPERTY_BUNDLE_ID = "BundleId";
    public static final String PROPERTY_BUNDLE_LOCATION = "Location";
    public static final String PROPERTY_BUNDLE_REV = "BundleRev";
    public static final String PROPERTY_LAST_MODIFIED = "LastModified";
    public static final String PROPERTY_PERSISTENTLY_STARTED = "PersistentlyStarted";
    public static final String PROPERTY_ACTIVATION_POLICY_USED = "ActivationPolicyUsed";
    public static final String PROPERTY_START_LEVEL = "StartLevel";
    public static final String BUNDLE_PERSISTENT_PROPERTIES = "bundle-persistent.properties";
    public static final String BUNDLE_DIRECTORY_PREFIX = "bundle-";
    private final File storageDir;
    private final VirtualFile rootFile;
    private final Properties props;
    private final String location;
    private final long bundleId;
    private final int revision;
    static Set<String> requiredProps = new HashSet<String>();

    public static StorageState createStorageState(File storageDir) throws IOException {
        VirtualFile rootFile = null;
        Properties props = StorageState.loadProperties(storageDir);
        String vfsLocation = props.getProperty(PROPERTY_BUNDLE_FILE);
        if (vfsLocation != null) {
            File revFile = new File(storageDir + "/" + vfsLocation);
            rootFile = AbstractVFS.toVirtualFile((URI)revFile.toURI());
        }
        StorageState storageState = new StorageState(storageDir, rootFile, props);
        FrameworkLogger.LOGGER.debugf("Created storage state: %s", storageState);
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageState createStorageState(File storageDir, VirtualFile rootFile, Properties props) throws IOException {
        StorageState storageState = new StorageState(storageDir, rootFile, props);
        if (rootFile != null) {
            String bundleId = props.getProperty(PROPERTY_BUNDLE_ID);
            String revision = props.getProperty(PROPERTY_BUNDLE_REV);
            File revFile = new File(storageDir + File.separator + BUNDLE_DIRECTORY_PREFIX + bundleId + "-rev-" + revision + ".jar");
            FileOutputStream output = new FileOutputStream(revFile);
            storageDir.mkdirs();
            InputStream input = rootFile.openStream();
            try {
                VFSUtils.copyStream((InputStream)input, (OutputStream)output);
            }
            finally {
                input.close();
                output.close();
            }
            props.put(PROPERTY_BUNDLE_FILE, revFile.getName());
        }
        storageState.writeProperties();
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File storageDir) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        File propsFile = new File(storageDir + "/" + BUNDLE_PERSISTENT_PROPERTIES);
        if (propsFile.exists()) {
            FileInputStream input = new FileInputStream(propsFile);
            try {
                props.load(input);
            }
            finally {
                VFSUtils.safeClose((Closeable)input);
            }
        }
        return props;
    }

    public StorageState(File storageDir, VirtualFile rootFile, Properties props) {
        assert (storageDir != null) : "Null storageFile";
        assert (props != null) : "Null properties";
        assert (storageDir.isDirectory()) : "Not a directory: " + storageDir;
        for (String key : requiredProps) {
            if (props.get(key) != null) continue;
            throw FrameworkMessages.MESSAGES.illegalArgumentRequiredPropertyMissing(key, storageDir);
        }
        this.storageDir = storageDir;
        this.rootFile = rootFile;
        this.props = props;
        this.location = props.getProperty(PROPERTY_BUNDLE_LOCATION);
        this.bundleId = Long.parseLong(props.getProperty(PROPERTY_BUNDLE_ID));
        this.revision = Integer.parseInt(props.getProperty(PROPERTY_BUNDLE_REV));
    }

    public Properties getProperties() {
        return this.props;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRootFile() {
        return this.rootFile;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getRevisionId() {
        return this.revision;
    }

    public long getLastModified() {
        String value = this.props.getProperty(PROPERTY_LAST_MODIFIED);
        return Long.parseLong(value);
    }

    public boolean isPersistentlyStarted() {
        String value = this.props.getProperty(PROPERTY_PERSISTENTLY_STARTED);
        return Boolean.parseBoolean(value);
    }

    public boolean isBundleActivationPolicyUsed() {
        String value = this.props.getProperty(PROPERTY_ACTIVATION_POLICY_USED);
        return Boolean.parseBoolean(value);
    }

    public int getStartLevel() {
        String value = this.props.getProperty(PROPERTY_START_LEVEL);
        return Integer.parseInt(value);
    }

    public void updateLastModified() {
        this.getProperties().setProperty(PROPERTY_LAST_MODIFIED, new Long(System.currentTimeMillis()).toString());
        this.writeProperties();
    }

    public void setPersistentlyStarted(boolean started) {
        this.getProperties().setProperty(PROPERTY_PERSISTENTLY_STARTED, new Boolean(started).toString());
        this.writeProperties();
    }

    public void setBundleActivationPolicyUsed(boolean usePolicy) {
        this.getProperties().setProperty(PROPERTY_ACTIVATION_POLICY_USED, new Boolean(usePolicy).toString());
        this.writeProperties();
    }

    public void setStartLevel(int level) {
        this.getProperties().setProperty(PROPERTY_START_LEVEL, new Integer(level).toString());
        this.writeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties() {
        try {
            File propsFile = new File(this.getStorageDir() + "/" + BUNDLE_PERSISTENT_PROPERTIES);
            FileOutputStream output = new FileOutputStream(propsFile);
            try {
                this.getProperties().store(output, "Persistent Bundle Properties");
            }
            finally {
                VFSUtils.safeClose((Closeable)output);
            }
        }
        catch (IOException ex) {
            FrameworkLogger.LOGGER.errorCannotWritePersistentStorage(ex, this.getStorageDir());
        }
    }

    public String toString() {
        int startlevel = this.getStartLevel();
        boolean started = this.isPersistentlyStarted();
        return "StorageState[id=" + this.bundleId + ",rev=" + this.revision + ",startlevel=" + startlevel + ",started=" + started + ",location=" + this.location + "]";
    }

    static {
        requiredProps.add(PROPERTY_BUNDLE_ID);
        requiredProps.add(PROPERTY_BUNDLE_REV);
        requiredProps.add(PROPERTY_BUNDLE_LOCATION);
        requiredProps.add(PROPERTY_START_LEVEL);
        requiredProps.add(PROPERTY_LAST_MODIFIED);
    }
}

