/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.enhancements.EnhancementsCategoryTokenizer;
import org.apache.lucene.facet.enhancements.params.EnhancementsIndexingParams;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.index.streaming.CategoryAttributesStream;
import org.apache.lucene.facet.index.streaming.CategoryListTokenizer;
import org.apache.lucene.facet.index.streaming.CategoryParentsStream;
import org.apache.lucene.facet.index.streaming.CategoryTokenizer;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;

public class EnhancementsDocumentBuilder
extends CategoryDocumentBuilder {
    public EnhancementsDocumentBuilder(TaxonomyWriter taxonomyWriter, EnhancementsIndexingParams params) throws IOException {
        super(taxonomyWriter, params);
    }

    @Override
    protected TokenStream getParentsStream(CategoryAttributesStream categoryAttributesStream) {
        List<Class<? extends CategoryProperty>> toRetainList = ((EnhancementsIndexingParams)this.indexingParams).getRetainableProperties();
        if (toRetainList != null) {
            CategoryParentsStream categoryParentsStream = new CategoryParentsStream(categoryAttributesStream, this.taxonomyWriter, this.indexingParams);
            for (Class<? extends CategoryProperty> toRetain : toRetainList) {
                categoryParentsStream.addRetainableProperty(toRetain);
            }
            return categoryParentsStream;
        }
        return super.getParentsStream(categoryAttributesStream);
    }

    @Override
    protected CategoryListTokenizer getCategoryListTokenizer(TokenStream categoryStream) {
        CategoryListTokenizer tokenizer = super.getCategoryListTokenizer(categoryStream);
        for (CategoryEnhancement enhancement : ((EnhancementsIndexingParams)this.indexingParams).getCategoryEnhancements()) {
            if (!enhancement.generatesCategoryList()) continue;
            tokenizer = enhancement.getCategoryListTokenizer((TokenStream)tokenizer, (EnhancementsIndexingParams)this.indexingParams, this.taxonomyWriter);
        }
        return tokenizer;
    }

    @Override
    protected CategoryTokenizer getCategoryTokenizer(TokenStream categoryStream) throws IOException {
        return new EnhancementsCategoryTokenizer(categoryStream, (EnhancementsIndexingParams)this.indexingParams);
    }
}

