/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements.association;

import org.apache.lucene.facet.enhancements.association.AssociationProperty;
import org.apache.lucene.facet.index.attributes.CategoryProperty;

public class AssociationFloatProperty
extends AssociationProperty {
    public AssociationFloatProperty(float value) {
        super(Float.floatToIntBits(value));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AssociationFloatProperty)) {
            return false;
        }
        AssociationFloatProperty o = (AssociationFloatProperty)other;
        return o.association == this.association;
    }

    public int hashCode() {
        return "AssociationFloatProperty".hashCode() * 31 + (int)this.association;
    }

    @Override
    public void merge(CategoryProperty other) {
        AssociationFloatProperty o = (AssociationFloatProperty)other;
        this.association = Float.floatToIntBits(Float.intBitsToFloat((int)this.association) + Float.intBitsToFloat((int)o.association));
    }

    public float getFloatAssociation() {
        return Float.intBitsToFloat((int)this.association);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + Float.intBitsToFloat(this.getAssociation());
    }
}

