/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.adaptive;

import java.util.List;
import org.apache.lucene.facet.example.ExampleResult;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.adaptive.AdaptiveSearcher;
import org.apache.lucene.facet.example.simple.SimpleIndexer;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class AdaptiveMain {
    public static void main(String[] args) throws Exception {
        new AdaptiveMain().runSample();
        ExampleUtils.log("DONE");
    }

    public ExampleResult runSample() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        RAMDirectory taxoDir = new RAMDirectory();
        ExampleUtils.log("index the adaptive sample documents...");
        SimpleIndexer.index((Directory)indexDir, (Directory)taxoDir);
        ExampleUtils.log("search the adaptive sample documents...");
        List<FacetResult> facetRes = AdaptiveSearcher.searchWithFacets((Directory)indexDir, (Directory)taxoDir);
        ExampleResult res = new ExampleResult();
        res.setFacetResults(facetRes);
        return res;
    }
}

