/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.adaptive;

import java.util.List;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.search.AdaptiveFacetsAccumulator;
import org.apache.lucene.facet.search.ScoredDocIdCollector;
import org.apache.lucene.facet.search.params.CountFacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;

public class AdaptiveSearcher {
    public static List<FacetResult> searchWithFacets(Directory indexDir, Directory taxoDir) throws Exception {
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader(taxoDir);
        IndexReader indexReader = IndexReader.open((Directory)indexDir);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TermQuery q = new TermQuery(new Term("text", "white"));
        ExampleUtils.log("Query: " + q);
        TopScoreDocCollector topDocsCollector = TopScoreDocCollector.create((int)10, (boolean)true);
        ScoredDocIdCollector docIdsCollecor = ScoredDocIdCollector.create(indexReader.maxDoc(), false);
        FacetSearchParams facetSearchParams = new FacetSearchParams();
        facetSearchParams.addFacetRequest(new CountFacetRequest(new CategoryPath("root", "a"), 10));
        searcher.search((Query)q, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, docIdsCollecor}));
        AdaptiveFacetsAccumulator accumulator = new AdaptiveFacetsAccumulator(facetSearchParams, indexReader, taxo);
        List<FacetResult> res = accumulator.accumulate(docIdsCollecor.getScoredDocIDs());
        int i = 0;
        for (FacetResult facetResult : res) {
            ExampleUtils.log("Res " + i++ + ": " + facetResult);
        }
        indexReader.close();
        taxo.close();
        return res;
    }
}

