/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.association;

import java.util.List;
import org.apache.lucene.facet.example.ExampleResult;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.association.AssociationIndexer;
import org.apache.lucene.facet.example.association.AssociationSearcher;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class AssociationMain {
    public static void main(String[] args) throws Exception {
        new AssociationMain().runSumIntAssociationSample();
        new AssociationMain().runSumFloatAssociationSample();
        ExampleUtils.log("DONE");
    }

    public ExampleResult runSumIntAssociationSample() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        RAMDirectory taxoDir = new RAMDirectory();
        ExampleUtils.log("index the sample documents...");
        AssociationIndexer.index((Directory)indexDir, (Directory)taxoDir);
        ExampleUtils.log("search the sample documents...");
        List<FacetResult> facetRes = AssociationSearcher.searchSumIntAssociation((Directory)indexDir, (Directory)taxoDir);
        ExampleResult res = new ExampleResult();
        res.setFacetResults(facetRes);
        return res;
    }

    public ExampleResult runSumFloatAssociationSample() throws Exception {
        RAMDirectory indexDir = new RAMDirectory();
        RAMDirectory taxoDir = new RAMDirectory();
        ExampleUtils.log("index the sample documents...");
        AssociationIndexer.index((Directory)indexDir, (Directory)taxoDir);
        ExampleUtils.log("search the sample documents...");
        List<FacetResult> facetRes = AssociationSearcher.searchSumFloatAssociation((Directory)indexDir, (Directory)taxoDir);
        ExampleResult res = new ExampleResult();
        res.setFacetResults(facetRes);
        return res;
    }
}

