/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.multiCL;

import java.util.List;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.params.CountFacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;

public class MultiCLSearcher {
    public static List<FacetResult> searchWithFacets(Directory indexDir, Directory taxoDir, FacetIndexingParams iParams) throws Exception {
        IndexReader indexReader = IndexReader.open((Directory)indexDir);
        DirectoryTaxonomyReader taxo = new DirectoryTaxonomyReader(taxoDir);
        List<FacetResult> results = MultiCLSearcher.searchWithFacets(indexReader, taxo, iParams);
        indexReader.close();
        taxo.close();
        return results;
    }

    public static List<FacetResult> searchWithFacets(IndexReader indexReader, TaxonomyReader taxo, FacetIndexingParams iParams) throws Exception {
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TermQuery q = new TermQuery(new Term("text", "Quis"));
        ExampleUtils.log("Query: " + q);
        TopScoreDocCollector topDocsCollector = TopScoreDocCollector.create((int)10, (boolean)true);
        FacetSearchParams facetSearchParams = new FacetSearchParams(iParams);
        facetSearchParams.addFacetRequest(new CountFacetRequest(new CategoryPath("5"), 10));
        facetSearchParams.addFacetRequest(new CountFacetRequest(new CategoryPath("5", "5"), 10));
        facetSearchParams.addFacetRequest(new CountFacetRequest(new CategoryPath("6", "2"), 10));
        FacetsCollector facetsCollector = new FacetsCollector(facetSearchParams, indexReader, taxo);
        searcher.search((Query)q, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, facetsCollector}));
        List<FacetResult> res = facetsCollector.getFacetResults();
        int i = 0;
        for (FacetResult facetResult : res) {
            ExampleUtils.log("Res " + i++ + ": " + facetResult);
        }
        return res;
    }
}

