/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.simple;

import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.simple.SimpleUtils;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class SimpleIndexer {
    public static void index(Directory indexDir, Directory taxoDir) throws Exception {
        IndexWriter iw = new IndexWriter(indexDir, new IndexWriterConfig(ExampleUtils.EXAMPLE_VER, SimpleUtils.analyzer));
        DirectoryTaxonomyWriter taxo = new DirectoryTaxonomyWriter(taxoDir, IndexWriterConfig.OpenMode.CREATE);
        int nDocsAdded = 0;
        int nFacetsAdded = 0;
        for (int docNum = 0; docNum < SimpleUtils.docTexts.length; ++docNum) {
            List<CategoryPath> facetList = SimpleUtils.categoryPathArrayToList(SimpleUtils.categories[docNum]);
            CategoryDocumentBuilder categoryDocBuilder = new CategoryDocumentBuilder(taxo).setCategoryPaths(facetList);
            Document doc = new Document();
            doc.add((Fieldable)new Field("title", SimpleUtils.docTitles[docNum], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("text", SimpleUtils.docTexts[docNum], Field.Store.NO, Field.Index.ANALYZED));
            categoryDocBuilder.build(doc);
            iw.addDocument(doc);
            ++nDocsAdded;
            nFacetsAdded += facetList.size();
        }
        taxo.commit();
        iw.commit();
        taxo.close();
        iw.close();
        ExampleUtils.log("Indexed " + nDocsAdded + " documents with overall " + nFacetsAdded + " facets.");
    }
}

