/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.simple;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.DrillDown;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.params.CountFacetRequest;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;

public class SimpleSearcher {
    public static List<FacetResult> searchWithFacets(IndexReader indexReader, TaxonomyReader taxoReader) throws Exception {
        CountFacetRequest facetRequest = new CountFacetRequest(new CategoryPath("root", "a"), 10);
        return SimpleSearcher.searchWithRequest(indexReader, taxoReader, null, facetRequest);
    }

    public static List<FacetResult> searchWithRequest(IndexReader indexReader, TaxonomyReader taxoReader, FacetIndexingParams indexingParams, FacetRequest ... facetRequests) throws Exception {
        TermQuery q = new TermQuery(new Term("text", "white"));
        return SimpleSearcher.searchWithRequestAndQuery((Query)q, indexReader, taxoReader, indexingParams, facetRequests);
    }

    public static List<FacetResult> searchWithRequestAndQuery(Query q, IndexReader indexReader, TaxonomyReader taxoReader, FacetIndexingParams indexingParams, FacetRequest ... facetRequests) throws Exception {
        ExampleUtils.log("Query: " + q);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopScoreDocCollector topDocsCollector = TopScoreDocCollector.create((int)10, (boolean)true);
        if (indexingParams == null) {
            indexingParams = new DefaultFacetIndexingParams();
        }
        FacetSearchParams facetSearchParams = new FacetSearchParams(indexingParams);
        for (FacetRequest frq : facetRequests) {
            facetSearchParams.addFacetRequest(frq);
        }
        FacetsCollector facetsCollector = new FacetsCollector(facetSearchParams, indexReader, taxoReader);
        searcher.search(q, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, facetsCollector}));
        List<FacetResult> res = facetsCollector.getFacetResults();
        int i = 0;
        for (FacetResult facetResult : res) {
            ExampleUtils.log("Res " + i++ + ": " + facetResult);
        }
        return res;
    }

    public static List<FacetResult> searchWithDrillDown(IndexReader indexReader, TaxonomyReader taxoReader) throws Exception {
        TermQuery baseQuery = new TermQuery(new Term("text", "white"));
        CountFacetRequest facetRequest = new CountFacetRequest(new CategoryPath("root", "a"), 10);
        List<FacetResult> res1 = SimpleSearcher.searchWithRequest(indexReader, taxoReader, null, facetRequest);
        FacetResult fres = res1.get(0);
        Iterator<? extends FacetResultNode> resIterator = fres.getFacetResultNode().getSubResults().iterator();
        resIterator.next();
        CategoryPath categoryOfInterest = resIterator.next().getLabel();
        Query q2 = DrillDown.query((Query)baseQuery, categoryOfInterest);
        return SimpleSearcher.searchWithRequestAndQuery(q2, indexReader, taxoReader, null, facetRequest);
    }
}

