/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.index.attributes.CategoryAttribute;
import org.apache.lucene.facet.index.attributes.CategoryAttributesIterable;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.index.streaming.CategoryAttributesStream;
import org.apache.lucene.facet.index.streaming.CategoryListTokenizer;
import org.apache.lucene.facet.index.streaming.CategoryParentsStream;
import org.apache.lucene.facet.index.streaming.CategoryTokenizer;
import org.apache.lucene.facet.index.streaming.CountingListTokenizer;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;

public class CategoryDocumentBuilder {
    protected final TaxonomyWriter taxonomyWriter;
    protected final FacetIndexingParams indexingParams;
    protected final ArrayList<Field> fieldList = new ArrayList();
    protected Map<String, List<CategoryAttribute>> categoriesMap;

    public CategoryDocumentBuilder(TaxonomyWriter taxonomyWriter) throws IOException {
        this(taxonomyWriter, new DefaultFacetIndexingParams());
    }

    public CategoryDocumentBuilder(TaxonomyWriter taxonomyWriter, FacetIndexingParams params) throws IOException {
        this.taxonomyWriter = taxonomyWriter;
        this.indexingParams = params;
        this.categoriesMap = new HashMap<String, List<CategoryAttribute>>();
    }

    public CategoryDocumentBuilder setCategoryPaths(Iterable<CategoryPath> categoryPaths) throws IOException {
        if (categoryPaths == null) {
            this.fieldList.clear();
            return this;
        }
        return this.setCategories(new CategoryAttributesIterable(categoryPaths));
    }

    public CategoryDocumentBuilder setCategories(Iterable<CategoryAttribute> categories) throws IOException {
        this.fieldList.clear();
        if (categories == null) {
            return this;
        }
        this.fillCategoriesMap(categories);
        for (Map.Entry<String, List<CategoryAttribute>> e : this.categoriesMap.entrySet()) {
            CategoryAttributesStream categoryAttributesStream = new CategoryAttributesStream((Iterable<CategoryAttribute>)e.getValue());
            CategoryParentsStream parentsStream = (CategoryParentsStream)this.getParentsStream(categoryAttributesStream);
            CategoryListTokenizer categoryListTokenizer = this.getCategoryListTokenizer((TokenStream)parentsStream);
            CategoryTokenizer stream = this.getCategoryTokenizer((TokenStream)categoryListTokenizer);
            this.fieldList.add(new Field(e.getKey(), (TokenStream)stream));
        }
        return this;
    }

    protected TokenStream getParentsStream(CategoryAttributesStream categoryAttributesStream) {
        return new CategoryParentsStream(categoryAttributesStream, this.taxonomyWriter, this.indexingParams);
    }

    protected void fillCategoriesMap(Iterable<CategoryAttribute> categories) throws IOException {
        this.categoriesMap.clear();
        for (CategoryAttribute category : categories) {
            String fieldName = this.indexingParams.getCategoryListParams(category.getCategoryPath()).getTerm().field();
            List<CategoryAttribute> list = this.categoriesMap.get(fieldName);
            if (list == null) {
                list = new ArrayList<CategoryAttribute>();
                this.categoriesMap.put(fieldName, list);
            }
            list.add(category.clone());
        }
    }

    protected CategoryListTokenizer getCategoryListTokenizer(TokenStream categoryStream) {
        return this.getCountingListTokenizer(categoryStream);
    }

    protected CountingListTokenizer getCountingListTokenizer(TokenStream categoryStream) {
        return new CountingListTokenizer(categoryStream, this.indexingParams);
    }

    protected CategoryTokenizer getCategoryTokenizer(TokenStream categoryStream) throws IOException {
        return new CategoryTokenizer(categoryStream, this.indexingParams);
    }

    public Document build(Document doc) {
        for (Field f : this.fieldList) {
            f.setOmitNorms(true);
            doc.add((Fieldable)f);
        }
        return doc;
    }
}

