/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.streaming;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.index.streaming.CategoryTokenizerBase;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class CategoryTokenizer
extends CategoryTokenizerBase {
    public CategoryTokenizer(TokenStream input, FacetIndexingParams indexingParams) {
        super(input, indexingParams);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.categoryAttribute != null && this.categoryAttribute.getCategoryPath() != null) {
                CategoryPath categoryPath = this.categoryAttribute.getCategoryPath();
                char[] termBuffer = this.termAttribute.resizeBuffer(categoryPath.charsNeededForFullPath());
                int nChars = this.indexingParams.drillDownTermText(categoryPath, termBuffer);
                this.termAttribute.setLength(nChars);
                this.setPayload();
            }
            return true;
        }
        return false;
    }

    protected void setPayload() {
    }
}

