/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.PayloadIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.UnsafeByteArrayInputStream;
import org.apache.lucene.util.encoding.IntDecoder;

public class PayloadIntDecodingIterator
implements CategoryListIterator {
    private final UnsafeByteArrayInputStream ubais;
    private final IntDecoder decoder;
    private final IndexReader indexReader;
    private final Term term;
    private final PayloadIterator pi;
    private final int hashCode;

    public PayloadIntDecodingIterator(IndexReader indexReader, Term term, IntDecoder decoder) throws IOException {
        this(indexReader, term, decoder, new byte[1024]);
    }

    public PayloadIntDecodingIterator(IndexReader indexReader, Term term, IntDecoder decoder, byte[] buffer) throws IOException {
        this.pi = new PayloadIterator(indexReader, term, buffer);
        this.ubais = new UnsafeByteArrayInputStream();
        this.decoder = decoder;
        this.hashCode = indexReader.hashCode() ^ term.hashCode();
        this.term = term;
        this.indexReader = indexReader;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PayloadIntDecodingIterator)) {
            return false;
        }
        PayloadIntDecodingIterator that = (PayloadIntDecodingIterator)other;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.indexReader.equals(that.indexReader) && this.term.equals((Object)that.term);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean init() throws IOException {
        return this.pi.init();
    }

    @Override
    public long nextCategory() throws IOException {
        return this.decoder.decode();
    }

    @Override
    public boolean skipTo(int docId) throws IOException {
        if (!this.pi.setdoc(docId)) {
            return false;
        }
        this.ubais.reInit(this.pi.getBuffer(), 0, this.pi.getPayloadLength());
        this.decoder.reInit(this.ubais);
        return true;
    }
}

