/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FloatArrayAllocator;
import org.apache.lucene.facet.search.IntArrayAllocator;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.facet.search.TotalFacetCounts;
import org.apache.lucene.facet.search.TotalFacetCountsCache;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.IntermediateFacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.facet.util.ScoredDocIdsUtils;
import org.apache.lucene.index.IndexReader;

public class StandardFacetsAccumulator
extends FacetsAccumulator {
    private static final Logger logger = Logger.getLogger(StandardFacetsAccumulator.class.getName());
    protected final IntArrayAllocator intArrayAllocator;
    protected final FloatArrayAllocator floatArrayAllocator;
    protected int partitionSize;
    protected int maxPartitions;
    protected boolean isUsingComplements;
    private TotalFacetCounts totalFacetCounts;
    private Object accumulateGuard;

    public StandardFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, IntArrayAllocator intArrayAllocator, FloatArrayAllocator floatArrayAllocator) {
        super(searchParams, indexReader, taxonomyReader);
        int realPartitionSize = intArrayAllocator == null || floatArrayAllocator == null ? PartitionsUtils.partitionSize(searchParams, taxonomyReader) : -1;
        this.intArrayAllocator = intArrayAllocator != null ? intArrayAllocator : new IntArrayAllocator(realPartitionSize, 1);
        this.floatArrayAllocator = floatArrayAllocator != null ? floatArrayAllocator : new FloatArrayAllocator(realPartitionSize, 1);
        this.isUsingComplements = false;
        this.partitionSize = PartitionsUtils.partitionSize(searchParams, taxonomyReader);
        this.maxPartitions = (int)Math.ceil((double)this.taxonomyReader.getSize() / (double)this.partitionSize);
        this.accumulateGuard = new Object();
    }

    public StandardFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this(searchParams, indexReader, taxonomyReader, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        Object object = this.accumulateGuard;
        synchronized (object) {
            this.isUsingComplements = this.shouldComplement(docids);
            if (this.isUsingComplements) {
                try {
                    this.totalFacetCounts = TotalFacetCountsCache.getSingleton().getTotalCounts(this.indexReader, this.taxonomyReader, this.searchParams.getFacetIndexingParams(), this.searchParams.getClCache());
                    if (this.totalFacetCounts != null) {
                        docids = ScoredDocIdsUtils.getComplementSet(docids, this.indexReader);
                    } else {
                        this.isUsingComplements = false;
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "IndexReader used does not support completents: ", e);
                    }
                    this.isUsingComplements = false;
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Failed to load/calculate total counts (complement counting disabled): ", e);
                    }
                    this.isUsingComplements = false;
                }
                catch (Exception e) {
                    IOException ioEx = new IOException("PANIC: Got unexpected exception while trying to get/calculate total counts: " + e.getMessage());
                    ioEx.initCause(e);
                    throw ioEx;
                }
            }
            docids = this.actualDocsToAccumulate(docids);
            FacetArrays facetArrays = new FacetArrays(this.intArrayAllocator, this.floatArrayAllocator);
            HashMap<FacetRequest, IntermediateFacetResult> fr2tmpRes = new HashMap<FacetRequest, IntermediateFacetResult>();
            try {
                for (int part = 0; part < this.maxPartitions; ++part) {
                    this.fillArraysForPartition(docids, facetArrays, part);
                    int offset = part * this.partitionSize;
                    for (FacetRequest fr : this.searchParams.getFacetRequests()) {
                        FacetResultsHandler frHndlr = fr.createFacetResultsHandler(this.taxonomyReader);
                        IntermediateFacetResult res4fr = frHndlr.fetchPartitionResult(facetArrays, offset);
                        IntermediateFacetResult oldRes = (IntermediateFacetResult)fr2tmpRes.get(fr);
                        if (oldRes != null) {
                            res4fr = frHndlr.mergeResults(oldRes, res4fr);
                        }
                        fr2tmpRes.put(fr, res4fr);
                    }
                }
            }
            finally {
                facetArrays.free();
            }
            ArrayList<FacetResult> res = new ArrayList<FacetResult>();
            for (FacetRequest fr : this.searchParams.getFacetRequests()) {
                FacetResultsHandler frHndlr = fr.createFacetResultsHandler(this.taxonomyReader);
                IntermediateFacetResult tmpResult = (IntermediateFacetResult)fr2tmpRes.get(fr);
                if (tmpResult == null) continue;
                FacetResult facetRes = frHndlr.renderFacetResult(tmpResult);
                if (this.isAllowLabeling()) {
                    frHndlr.labelResult(facetRes);
                }
                res.add(facetRes);
            }
            return res;
        }
    }

    protected ScoredDocIDs actualDocsToAccumulate(ScoredDocIDs docids) throws IOException {
        return docids;
    }

    protected boolean shouldComplement(ScoredDocIDs docids) {
        return this.mayComplement() && (double)docids.size() > (double)this.indexReader.numDocs() * this.getComplementThreshold();
    }

    private final void fillArraysForPartition(ScoredDocIDs docids, FacetArrays facetArrays, int partition) throws IOException {
        if (this.isUsingComplements) {
            this.initArraysByTotalCounts(facetArrays, partition, docids.size());
        } else {
            facetArrays.free();
        }
        HashMap<CategoryListIterator, Aggregator> categoryLists = this.getCategoryListMap(facetArrays, partition);
        for (Map.Entry<CategoryListIterator, Aggregator> entry : categoryLists.entrySet()) {
            CategoryListIterator categoryList = entry.getKey();
            if (!categoryList.init()) continue;
            Aggregator categorator = entry.getValue();
            ScoredDocIDsIterator iterator = docids.iterator();
            while (iterator.next()) {
                long ordinal;
                int docID = iterator.getDocID();
                if (!categoryList.skipTo(docID)) continue;
                categorator.setNextDoc(docID, iterator.getScore());
                while ((ordinal = categoryList.nextCategory()) <= Integer.MAX_VALUE) {
                    categorator.aggregate((int)ordinal);
                }
            }
        }
    }

    private final void initArraysByTotalCounts(FacetArrays facetArrays, int partition, int nAccumulatedDocs) {
        int[] intArray = facetArrays.getIntArray();
        this.totalFacetCounts.fillTotalCountsForPartition(intArray, partition);
        double totalCountsFactor = this.getTotalCountsFactor();
        if (totalCountsFactor < 0.99999) {
            int delta = nAccumulatedDocs + 1;
            int i = 0;
            while (i < intArray.length) {
                int n = i;
                intArray[n] = (int)((double)intArray[n] * totalCountsFactor);
                int n2 = i++;
                intArray[n2] = intArray[n2] + delta;
            }
        }
    }

    protected double getTotalCountsFactor() {
        return 1.0;
    }

    protected HashMap<CategoryListIterator, Aggregator> getCategoryListMap(FacetArrays facetArrays, int partition) throws IOException {
        HashMap<CategoryListIterator, Aggregator> categoryLists = new HashMap<CategoryListIterator, Aggregator>();
        for (FacetRequest facetRequest : this.searchParams.getFacetRequests()) {
            Aggregator categoryAggregator = facetRequest.createAggregator(this.isUsingComplements, facetArrays, this.indexReader, this.taxonomyReader);
            CategoryListIterator cli = facetRequest.createCategoryListIterator(this.indexReader, this.taxonomyReader, this.searchParams, partition);
            Aggregator old = categoryLists.put(cli, categoryAggregator);
            if (old == null || old.equals(categoryAggregator)) continue;
            throw new RuntimeException("Overriding existing category list with different aggregator. THAT'S A NO NO!");
        }
        return categoryLists;
    }
}

