/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params;

import java.io.IOException;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.TopKFacetResultsHandler;
import org.apache.lucene.facet.search.TopKInEachNodeHandler;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.cache.CategoryListCache;
import org.apache.lucene.facet.search.cache.CategoryListData;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public abstract class FacetRequest
implements Cloneable {
    public static final int DEFAULT_DEPTH = 1;
    public static final SortBy DEFAULT_SORT_BY = SortBy.VALUE;
    public static final ResultMode DEFAULT_RESULT_MODE = ResultMode.GLOBAL_FLAT;
    private final CategoryPath categoryPath;
    private final int numResults;
    private int numLabel;
    private int depth;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private final int hashCode;
    private ResultMode resultMode = DEFAULT_RESULT_MODE;

    public FacetRequest(CategoryPath path, int numResults) {
        if (numResults <= 0) {
            throw new IllegalArgumentException("num results must be a positive (>0) number: " + numResults);
        }
        if (path == null) {
            throw new IllegalArgumentException("category path cannot be null!");
        }
        this.categoryPath = path;
        this.numResults = numResults;
        this.numLabel = numResults;
        this.depth = 1;
        this.sortBy = DEFAULT_SORT_BY;
        this.sortOrder = SortOrder.DESCENDING;
        this.hashCode = this.categoryPath.hashCode() ^ this.numResults;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setNumLabel(int numLabel) {
        this.numLabel = numLabel;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public final CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final int getNumLabel() {
        return this.numLabel;
    }

    public final int getNumResults() {
        return this.numResults;
    }

    public final SortBy getSortBy() {
        return this.sortBy;
    }

    public final SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return this.categoryPath.toString() + " nRes=" + this.numResults + " nLbl=" + this.numLabel;
    }

    public FacetResultsHandler createFacetResultsHandler(TaxonomyReader taxonomyReader) {
        try {
            if (this.resultMode == ResultMode.PER_NODE_IN_TREE) {
                return new TopKInEachNodeHandler(taxonomyReader, (FacetRequest)this.clone());
            }
            return new TopKFacetResultsHandler(taxonomyReader, (FacetRequest)this.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final ResultMode getResultMode() {
        return this.resultMode;
    }

    public void setResultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof FacetRequest) {
            FacetRequest that = (FacetRequest)o;
            return that.hashCode == this.hashCode && that.categoryPath.equals(this.categoryPath) && that.numResults == this.numResults && that.depth == this.depth && that.resultMode == this.resultMode && that.numLabel == this.numLabel;
        }
        return false;
    }

    public abstract Aggregator createAggregator(boolean var1, FacetArrays var2, IndexReader var3, TaxonomyReader var4) throws IOException;

    public CategoryListIterator createCategoryListIterator(IndexReader reader, TaxonomyReader taxo, FacetSearchParams sParams, int partition) throws IOException {
        CategoryListData clData;
        CategoryListCache clCache = sParams.getClCache();
        CategoryListParams clParams = sParams.getFacetIndexingParams().getCategoryListParams(this.categoryPath);
        if (clCache != null && (clData = clCache.get(clParams)) != null) {
            return clData.iterator(partition);
        }
        return clParams.createCategoryListIterator(reader, partition);
    }

    public abstract double getValueOf(FacetArrays var1, int var2);

    public boolean supportsComplements() {
        return false;
    }

    public abstract boolean requireDocumentScore();

    public static enum ResultMode {
        PER_NODE_IN_TREE,
        GLOBAL_FLAT;

    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    public static enum SortBy {
        ORDINAL,
        VALUE;

    }
}

