/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public class MutableFacetResultNode
implements FacetResultNode {
    private static final ArrayList<FacetResultNode> EMPTY_SUB_RESULTS = new ArrayList();
    private int ordinal;
    private CategoryPath label = null;
    private double value;
    private double residue;
    private List<FacetResultNode> subResults;

    public MutableFacetResultNode(int ordinal, double value) {
        this(ordinal, value, 0.0, null, null);
    }

    public void reset(int ordinal, double value) {
        this.ordinal = ordinal;
        this.value = value;
        if (this.subResults != null) {
            this.subResults.clear();
        }
        this.label = null;
        this.residue = 0.0;
    }

    public MutableFacetResultNode(int ordinal, double value, double residue, CategoryPath label, List<FacetResultNode> subResults) {
        this.ordinal = ordinal;
        this.value = value;
        this.residue = residue;
        this.label = label;
        this.subResults = subResults;
    }

    public MutableFacetResultNode(FacetResultNode other, boolean takeSubResults) {
        this(other.getOrdinal(), other.getValue(), other.getResidue(), other.getLabel(), takeSubResults ? MutableFacetResultNode.resultsToList(other.getSubResults()) : null);
    }

    private static List<FacetResultNode> resultsToList(Iterable<? extends FacetResultNode> subResults) {
        if (subResults == null) {
            return null;
        }
        ArrayList<FacetResultNode> res = new ArrayList<FacetResultNode>();
        for (FacetResultNode facetResultNode : subResults) {
            res.add(facetResultNode);
        }
        return res;
    }

    public String toString() {
        return this.toString("");
    }

    private int numSubResults() {
        if (this.subResults == null) {
            return 0;
        }
        return this.subResults.size();
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append("Facet Result Node with ").append(this.numSubResults()).append(" sub result nodes.\n");
        sb.append(prefix).append("Name: ").append(this.getLabel()).append("\n");
        sb.append(prefix).append("Value: ").append(this.value).append("\n");
        sb.append(prefix).append("Residue: ").append(this.residue).append("\n");
        if (this.subResults != null) {
            int i = 0;
            for (FacetResultNode subRes : this.subResults) {
                sb.append("\n").append(prefix).append("Subresult #").append(i++).append("\n").append(subRes.toString(prefix + "\t"));
            }
        }
        return sb.toString();
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final CategoryPath getLabel() {
        return this.label;
    }

    public void setLabel(CategoryPath label) {
        this.label = label;
    }

    @Override
    public final double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void increaseValue(double addedValue) {
        this.value += addedValue;
    }

    @Override
    public final double getResidue() {
        return this.residue;
    }

    public void setResidue(double residue) {
        this.residue = residue;
    }

    public void increaseResidue(double addedResidue) {
        this.residue += addedResidue;
    }

    @Override
    public final Iterable<? extends FacetResultNode> getSubResults() {
        return this.subResults != null ? this.subResults : EMPTY_SUB_RESULTS;
    }

    public void trimSubResults(int size) {
        int i;
        if (this.subResults == null || this.subResults.size() == 0) {
            return;
        }
        ArrayList<FacetResultNode> trimmed = new ArrayList<FacetResultNode>(size);
        for (i = 0; i < this.subResults.size() && i < size; ++i) {
            MutableFacetResultNode trimmedNode = MutableFacetResultNode.toImpl(this.subResults.get(i));
            trimmedNode.trimSubResults(size);
            trimmed.add(trimmedNode);
        }
        for (i = size; i < this.subResults.size(); ++i) {
            this.increaseResidue(this.subResults.get(i).getValue());
        }
        this.subResults = trimmed;
    }

    public void setSubResults(List<FacetResultNode> subResults) {
        this.subResults = subResults;
    }

    public void appendSubResult(FacetResultNode subRes) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<FacetResultNode>();
        }
        this.subResults.add(subRes);
    }

    public void insertSubResult(FacetResultNode subRes) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<FacetResultNode>();
        }
        this.subResults.add(0, subRes);
    }

    @Override
    public final CategoryPath getLabel(TaxonomyReader taxonomyReader) throws IOException {
        if (this.label == null) {
            this.label = taxonomyReader.getPath(this.ordinal);
        }
        return this.label;
    }

    @Override
    public final int getNumSubResults() {
        return this.subResults == null ? 0 : this.subResults.size();
    }

    public static MutableFacetResultNode toImpl(FacetResultNode frn) {
        if (frn instanceof MutableFacetResultNode) {
            return (MutableFacetResultNode)frn;
        }
        return new MutableFacetResultNode(frn, true);
    }
}

