/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.sampling;

import java.io.IOException;
import org.apache.lucene.facet.search.DrillDown;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.facet.search.sampling.SampleFixer;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

class TakmiSampleFixer
implements SampleFixer {
    private TaxonomyReader taxonomyReader;
    private IndexReader indexReader;
    private FacetSearchParams searchParams;

    public TakmiSampleFixer(IndexReader indexReader, TaxonomyReader taxonomyReader, FacetSearchParams searchParams) {
        this.indexReader = indexReader;
        this.taxonomyReader = taxonomyReader;
        this.searchParams = searchParams;
    }

    @Override
    public void fixResult(ScoredDocIDs origDocIds, FacetResult fres) throws IOException {
        FacetResultNode topRes = fres.getFacetResultNode();
        this.fixResultNode(topRes, origDocIds);
    }

    private void fixResultNode(FacetResultNode facetResNode, ScoredDocIDs docIds) throws IOException {
        this.recount(facetResNode, docIds);
        for (FacetResultNode facetResultNode : facetResNode.getSubResults()) {
            this.fixResultNode(facetResultNode, docIds);
        }
    }

    private void recount(FacetResultNode fresNode, ScoredDocIDs docIds) throws IOException {
        CategoryPath catPath = fresNode.getLabel(this.taxonomyReader);
        Term drillDownTerm = DrillDown.term(this.searchParams, catPath);
        int updatedCount = TakmiSampleFixer.countIntersection(this.indexReader.termDocs(drillDownTerm), docIds.iterator());
        fresNode.setValue(updatedCount);
    }

    private static int countIntersection(TermDocs p1, ScoredDocIDsIterator p2) throws IOException {
        if (!p1.next()) {
            return 0;
        }
        if (!p2.next()) {
            return 0;
        }
        int d1 = p1.doc();
        int d2 = p2.getDocID();
        int count = 0;
        while (true) {
            if (d1 == d2) {
                ++count;
                if (!p1.next() || !TakmiSampleFixer.advance(p2, d1 = p1.doc())) break;
                d2 = p2.getDocID();
                continue;
            }
            if (d1 < d2) {
                if (!p1.skipTo(d2)) break;
                d1 = p1.doc();
                continue;
            }
            if (!TakmiSampleFixer.advance(p2, d1)) break;
            d2 = p2.getDocID();
        }
        return count;
    }

    private static boolean advance(ScoredDocIDsIterator iterator, int targetDoc) {
        while (iterator.next()) {
            if (iterator.getDocID() < targetDoc) continue;
            return true;
        }
        return false;
    }
}

