/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;

public class CategoryPath
implements Serializable,
Cloneable,
Comparable<CategoryPath> {
    protected char[] chars;
    protected short[] ends;
    protected short ncomponents;

    public short length() {
        return this.ncomponents;
    }

    public void trim(int nTrim) {
        if (nTrim >= this.ncomponents) {
            this.clear();
        } else if (nTrim > 0) {
            this.ncomponents = (short)(this.ncomponents - nTrim);
        }
    }

    public int capacityChars() {
        return this.chars.length;
    }

    public int capacityComponents() {
        return this.ends.length;
    }

    public CategoryPath(int capacityChars, int capacityComponents) {
        this.ncomponents = 0;
        this.chars = new char[capacityChars];
        this.ends = new short[capacityComponents];
    }

    public CategoryPath() {
        this(0, 0);
    }

    public void add(CharSequence component) {
        if (this.ncomponents >= this.ends.length) {
            short[] newends = new short[(this.ends.length + 1) * 2];
            System.arraycopy(this.ends, 0, newends, 0, this.ends.length);
            this.ends = newends;
        }
        short prevend = this.ncomponents == 0 ? (short)0 : this.ends[this.ncomponents - 1];
        int cmplen = component.length();
        this.ends[this.ncomponents] = (short)(prevend + cmplen);
        if (this.ends[this.ncomponents] > this.chars.length) {
            char[] newchars = new char[this.ends[this.ncomponents] * 2];
            System.arraycopy(this.chars, 0, newchars, 0, this.chars.length);
            this.chars = newchars;
        }
        for (int i = 0; i < cmplen; ++i) {
            short s = prevend;
            prevend = (short)(prevend + 1);
            this.chars[s] = component.charAt(i);
        }
        this.ncomponents = (short)(this.ncomponents + 1);
    }

    public void clear() {
        this.ncomponents = 0;
    }

    public void appendTo(Appendable out, char delimiter) throws IOException {
        if (this.ncomponents == 0) {
            return;
        }
        for (int i = 0; i < this.ends[0]; ++i) {
            out.append(this.chars[i]);
        }
        for (int j = 1; j < this.ncomponents; ++j) {
            out.append(delimiter);
            for (int i = this.ends[j - 1]; i < this.ends[j]; ++i) {
                out.append(this.chars[i]);
            }
        }
    }

    public void appendTo(Appendable out, char delimiter, int prefixLen) throws IOException {
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        if (prefixLen == 0) {
            return;
        }
        for (int i = 0; i < this.ends[0]; ++i) {
            out.append(this.chars[i]);
        }
        for (int j = 1; j < prefixLen; ++j) {
            out.append(delimiter);
            for (int i = this.ends[j - 1]; i < this.ends[j]; ++i) {
                out.append(this.chars[i]);
            }
        }
    }

    public void appendTo(Appendable out, char delimiter, int start, int end) throws IOException {
        int i;
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end > this.ncomponents) {
            end = this.ncomponents;
        }
        if (end <= start) {
            return;
        }
        int n = i = start == 0 ? 0 : this.ends[start - 1];
        while (i < this.ends[start]) {
            out.append(this.chars[i]);
            ++i;
        }
        for (int j = start + 1; j < end; ++j) {
            out.append(delimiter);
            for (int i2 = this.ends[j - 1]; i2 < this.ends[j]; ++i2) {
                out.append(this.chars[i2]);
            }
        }
    }

    public String toString(char delimiter) {
        if (this.ncomponents == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.ends[this.ncomponents - 1] + (this.ncomponents - 1));
        try {
            this.appendTo(sb, delimiter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString('/');
    }

    public String toString(char delimiter, int prefixLen) {
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        if (prefixLen == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.ends[prefixLen - 1] + (prefixLen - 1));
        try {
            this.appendTo(sb, delimiter, prefixLen);
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    public String toString(char delimiter, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end > this.ncomponents) {
            end = this.ncomponents;
        }
        if (end <= start) {
            return "";
        }
        short startchar = start == 0 ? (short)0 : this.ends[start - 1];
        StringBuilder sb = new StringBuilder(this.ends[end - 1] - startchar + (end - start) - 1);
        try {
            this.appendTo(sb, delimiter, start, end);
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getComponent(int i) {
        if (i < 0 || i >= this.ncomponents) {
            return null;
        }
        if (i == 0) {
            return new String(this.chars, 0, (int)this.ends[0]);
        }
        return new String(this.chars, (int)this.ends[i - 1], this.ends[i] - this.ends[i - 1]);
    }

    public String lastComponent() {
        if (this.ncomponents == 0) {
            return null;
        }
        if (this.ncomponents == 1) {
            return new String(this.chars, 0, (int)this.ends[0]);
        }
        return new String(this.chars, (int)this.ends[this.ncomponents - 2], this.ends[this.ncomponents - 1] - this.ends[this.ncomponents - 2]);
    }

    public int copyToCharArray(char[] outputBuffer, int outputBufferStart, int numberOfComponentsToCopy, char separatorChar) {
        if (numberOfComponentsToCopy == 0) {
            return 0;
        }
        if (numberOfComponentsToCopy < 0 || numberOfComponentsToCopy > this.ncomponents) {
            numberOfComponentsToCopy = this.ncomponents;
        }
        int outputBufferInitialStart = outputBufferStart;
        short sourceStart = 0;
        int sourceLength = this.ends[0];
        for (int component = 0; component < numberOfComponentsToCopy; ++component) {
            if (component > 0) {
                sourceStart = this.ends[component - 1];
                sourceLength = this.ends[component] - sourceStart;
                outputBuffer[outputBufferStart++] = separatorChar;
            }
            System.arraycopy(this.chars, sourceStart, outputBuffer, outputBufferStart, sourceLength);
            outputBufferStart += sourceLength;
        }
        return outputBufferStart - outputBufferInitialStart;
    }

    public int charsNeededForFullPath() {
        if (this.ncomponents == 0) {
            return 0;
        }
        return this.ends[this.ncomponents - 1] + this.ncomponents - 1;
    }

    public CategoryPath(String pathString, char delimiter) {
        if (pathString.length() == 0) {
            this.ncomponents = 0;
            this.chars = new char[0];
            this.ends = new short[0];
            return;
        }
        int nparts = 1;
        int i = pathString.indexOf(delimiter);
        while (i >= 0) {
            ++nparts;
            i = pathString.indexOf(delimiter, i + 1);
        }
        this.ends = new short[nparts];
        this.chars = new char[pathString.length() - nparts + 1];
        this.ncomponents = 0;
        this.add(pathString, delimiter);
    }

    public void add(CharSequence pathString, char delimiter) {
        int len = pathString.length();
        if (len == 0) {
            return;
        }
        short pos = this.ncomponents == 0 ? (short)0 : this.ends[this.ncomponents - 1];
        for (int i = 0; i < len; ++i) {
            char c = pathString.charAt(i);
            if (c == delimiter) {
                if (this.ncomponents >= this.ends.length) {
                    short[] newends = new short[(this.ends.length + 1) * 2];
                    System.arraycopy(this.ends, 0, newends, 0, this.ends.length);
                    this.ends = newends;
                }
                short s = this.ncomponents;
                this.ncomponents = (short)(s + 1);
                this.ends[s] = pos;
                continue;
            }
            if (pos >= this.chars.length) {
                char[] newchars = new char[(this.chars.length + 1) * 2];
                System.arraycopy(this.chars, 0, newchars, 0, this.chars.length);
                this.chars = newchars;
            }
            short s = pos;
            pos = (short)(pos + 1);
            this.chars[s] = c;
        }
        if (this.ncomponents >= this.ends.length) {
            short[] newends = new short[(this.ends.length + 1) * 2];
            System.arraycopy(this.ends, 0, newends, 0, this.ends.length);
            this.ends = newends;
        }
        short s = this.ncomponents;
        this.ncomponents = (short)(s + 1);
        this.ends[s] = pos;
    }

    public CategoryPath(CharSequence ... components) {
        this.ncomponents = (short)components.length;
        this.ends = new short[this.ncomponents];
        if (this.ncomponents > 0) {
            this.ends[0] = (short)components[0].length();
            for (int i = 1; i < this.ncomponents; ++i) {
                this.ends[i] = (short)(this.ends[i - 1] + components[i].length());
            }
            this.chars = new char[this.ends[this.ncomponents - 1]];
            CharSequence cs = components[0];
            if (cs instanceof String) {
                ((String)cs).getChars(0, cs.length(), this.chars, 0);
            } else {
                int k = cs.length();
                for (int j = 0; j < k; ++j) {
                    this.chars[j] = cs.charAt(j);
                }
            }
            for (int i = 1; i < this.ncomponents; ++i) {
                cs = components[i];
                short offset = this.ends[i - 1];
                if (cs instanceof String) {
                    ((String)cs).getChars(0, cs.length(), this.chars, offset);
                    continue;
                }
                int k = cs.length();
                for (int j = 0; j < k; ++j) {
                    this.chars[j + offset] = cs.charAt(j);
                }
            }
        } else {
            this.chars = new char[0];
        }
    }

    public CategoryPath(CategoryPath existing) {
        this.ncomponents = existing.ncomponents;
        if (this.ncomponents == 0) {
            this.chars = new char[0];
            this.ends = new short[0];
            return;
        }
        this.chars = new char[existing.ends[this.ncomponents - 1]];
        System.arraycopy(existing.chars, 0, this.chars, 0, this.chars.length);
        this.ends = new short[this.ncomponents];
        System.arraycopy(existing.ends, 0, this.ends, 0, this.ends.length);
    }

    public CategoryPath(CategoryPath existing, int prefixLen) {
        this.ncomponents = prefixLen < 0 || prefixLen > existing.ncomponents ? existing.ncomponents : (short)prefixLen;
        if (this.ncomponents == 0) {
            this.chars = new char[0];
            this.ends = new short[0];
            return;
        }
        this.chars = new char[existing.ends[this.ncomponents - 1]];
        System.arraycopy(existing.chars, 0, this.chars, 0, this.chars.length);
        this.ends = new short[this.ncomponents];
        System.arraycopy(existing.ends, 0, this.ends, 0, this.ends.length);
    }

    public Object clone() {
        return new CategoryPath(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryPath) {
            CategoryPath other = (CategoryPath)obj;
            if (other.ncomponents != this.ncomponents) {
                return false;
            }
            if (this.ncomponents == 0) {
                return true;
            }
            for (int i = 0; i < this.ncomponents; ++i) {
                if (this.ends[i] == other.ends[i]) continue;
                return false;
            }
            int len = this.ends[this.ncomponents - 1];
            for (int i = 0; i < len; ++i) {
                if (this.chars[i] == other.chars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isDescendantOf(CategoryPath other) {
        if (this.ncomponents < other.ncomponents) {
            return false;
        }
        int j = 0;
        for (int i = 0; i < other.ncomponents; ++i) {
            if (this.ends[i] != other.ends[i]) {
                return false;
            }
            while (j < this.ends[i]) {
                if (this.chars[j] != other.chars[j]) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.ncomponents == 0) {
            return 0;
        }
        int hash = this.ncomponents;
        for (int i = 0; i < this.ncomponents; ++i) {
            hash = hash * 31 + this.ends[i];
        }
        int len = this.ends[this.ncomponents - 1];
        for (int i = 0; i < len; ++i) {
            hash = hash * 31 + this.chars[i];
        }
        return hash;
    }

    public int hashCode(int prefixLen) {
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        if (prefixLen == 0) {
            return 0;
        }
        int hash = prefixLen;
        for (int i = 0; i < prefixLen; ++i) {
            hash = hash * 31 + this.ends[i];
        }
        int len = this.ends[prefixLen - 1];
        for (int i = 0; i < len; ++i) {
            hash = hash * 31 + this.chars[i];
        }
        return hash;
    }

    public long longHashCode() {
        if (this.ncomponents == 0) {
            return 0L;
        }
        long hash = this.ncomponents;
        for (int i = 0; i < this.ncomponents; ++i) {
            hash = hash * 65599L + (long)this.ends[i];
        }
        int len = this.ends[this.ncomponents - 1];
        for (int i = 0; i < len; ++i) {
            hash = hash * 65599L + (long)this.chars[i];
        }
        return hash;
    }

    public long longHashCode(int prefixLen) {
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        if (prefixLen == 0) {
            return 0L;
        }
        long hash = prefixLen;
        for (int i = 0; i < prefixLen; ++i) {
            hash = hash * 65599L + (long)this.ends[i];
        }
        int len = this.ends[prefixLen - 1];
        for (int i = 0; i < len; ++i) {
            hash = hash * 65599L + (long)this.chars[i];
        }
        return hash;
    }

    public void serializeAppendTo(Appendable out) throws IOException {
        out.append((char)this.ncomponents);
        if (this.ncomponents == 0) {
            return;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            out.append((char)this.ends[i]);
        }
        int usedchars = this.ends[this.ncomponents - 1];
        for (int i = 0; i < usedchars; ++i) {
            out.append(this.chars[i]);
        }
    }

    public void serializeAppendTo(int prefixLen, Appendable out) throws IOException {
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        out.append((char)prefixLen);
        if (prefixLen == 0) {
            return;
        }
        for (int i = 0; i < prefixLen; ++i) {
            out.append((char)this.ends[i]);
        }
        int usedchars = this.ends[prefixLen - 1];
        for (int i = 0; i < usedchars; ++i) {
            out.append(this.chars[i]);
        }
    }

    public int setFromSerialized(CharSequence buffer, int offset) {
        this.ncomponents = (short)buffer.charAt(offset++);
        if (this.ncomponents == 0) {
            return offset;
        }
        if (this.ncomponents >= this.ends.length) {
            this.ends = new short[Math.max(this.ends.length * 2, this.ncomponents)];
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            this.ends[i] = (short)buffer.charAt(offset++);
        }
        int usedchars = this.ends[this.ncomponents - 1];
        if (usedchars > this.chars.length) {
            this.chars = new char[Math.max(this.chars.length * 2, usedchars)];
        }
        for (int i = 0; i < usedchars; ++i) {
            this.chars[i] = buffer.charAt(offset++);
        }
        return offset;
    }

    public boolean equalsToSerialized(CharSequence buffer, int offset) {
        short n;
        if (this.ncomponents != (n = (short)buffer.charAt(offset++))) {
            return false;
        }
        if (this.ncomponents == 0) {
            return true;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            if (this.ends[i] == (short)buffer.charAt(offset++)) continue;
            return false;
        }
        int usedchars = this.ends[this.ncomponents - 1];
        for (int i = 0; i < usedchars; ++i) {
            if (this.chars[i] == buffer.charAt(offset++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsToSerialized(int prefixLen, CharSequence buffer, int offset) {
        short n;
        if (prefixLen < 0 || prefixLen > this.ncomponents) {
            prefixLen = this.ncomponents;
        }
        if (prefixLen != (n = (short)buffer.charAt(offset++))) {
            return false;
        }
        if (prefixLen == 0) {
            return true;
        }
        for (int i = 0; i < prefixLen; ++i) {
            if (this.ends[i] == (short)buffer.charAt(offset++)) continue;
            return false;
        }
        int usedchars = this.ends[prefixLen - 1];
        for (int i = 0; i < usedchars; ++i) {
            if (this.chars[i] == buffer.charAt(offset++)) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeOfSerialized(CharSequence buffer, int offset) {
        int ncomponents;
        if ((ncomponents = (int)buffer.charAt(offset++)) == 0) {
            return 0;
        }
        int hash = ncomponents;
        for (int i = 0; i < ncomponents; ++i) {
            hash = hash * 31 + buffer.charAt(offset++);
        }
        int len = buffer.charAt(offset - 1);
        for (int i = 0; i < len; ++i) {
            hash = hash * 31 + buffer.charAt(offset++);
        }
        return hash;
    }

    public void serializeToStreamWriter(OutputStreamWriter osw) throws IOException {
        osw.write(this.ncomponents);
        if (this.ncomponents <= 0) {
            return;
        }
        for (int j = 0; j < this.ncomponents; ++j) {
            osw.write(this.ends[j]);
        }
        osw.write(this.chars, 0, (int)this.ends[this.ncomponents - 1]);
    }

    public void deserializeFromStreamReader(InputStreamReader isr) throws IOException {
        this.ncomponents = (short)isr.read();
        if (this.ncomponents <= 0) {
            return;
        }
        if (this.ends == null || this.ends.length < this.ncomponents) {
            this.ends = new short[this.ncomponents];
        }
        for (int j = 0; j < this.ncomponents; ++j) {
            this.ends[j] = (short)isr.read();
        }
        if (this.chars == null || this.ends[this.ncomponents - 1] > this.chars.length) {
            this.chars = new char[this.ends[this.ncomponents - 1]];
        }
        isr.read(this.chars, 0, this.ends[this.ncomponents - 1]);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        this.serializeToStreamWriter(osw);
        osw.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
        this.deserializeFromStreamReader(isr);
    }

    @Override
    public int compareTo(CategoryPath other) {
        int minlength = this.length() < other.length() ? this.length() : other.length();
        int ch = 0;
        for (int co = 0; co < minlength; ++co) {
            if (this.ends[co] <= other.ends[co]) {
                while (ch < this.ends[co]) {
                    if (this.chars[ch] != other.chars[ch]) {
                        return this.chars[ch] - other.chars[ch];
                    }
                    ++ch;
                }
                if (this.ends[co] >= other.ends[co]) continue;
                return -1;
            }
            while (ch < other.ends[co]) {
                if (this.chars[ch] != other.chars[ch]) {
                    return this.chars[ch] - other.chars[ch];
                }
                ++ch;
            }
            return 1;
        }
        return this.length() - other.length();
    }
}

