/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.InconsistentTaxonomyException;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.Consts;
import org.apache.lucene.facet.taxonomy.directory.ParentArray;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.collections.LRUHashMap;

public class DirectoryTaxonomyReader
implements TaxonomyReader {
    private static final Logger logger = Logger.getLogger(DirectoryTaxonomyReader.class.getName());
    private IndexReader indexReader;
    private ReadWriteLock indexReaderLock = new ReentrantReadWriteLock();
    private final LRUHashMap<String, Integer> ordinalCache;
    private final LRUHashMap<Integer, String> categoryCache;
    private ParentArray parentArray;
    private char delimiter = (char)63305;
    private volatile boolean closed = false;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private TaxonomyReader.ChildrenArrays childrenArrays;
    Object childrenArraysRebuild = new Object();

    public DirectoryTaxonomyReader(Directory directory) throws IOException {
        this.indexReader = this.openIndexReader(directory);
        this.ordinalCache = new LRUHashMap(4000);
        this.categoryCache = new LRUHashMap(4000);
        this.parentArray = new ParentArray();
        this.parentArray.refresh(this.indexReader);
    }

    protected IndexReader openIndexReader(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open((Directory)directory);
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.getRefCount() <= 0) {
            throw new AlreadyClosedException("this TaxonomyReader is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        this.ensureOpen();
        LRUHashMap<Object, Object> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            this.categoryCache.setMaxSize(size);
        }
        lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            this.ordinalCache.setMaxSize(size);
        }
    }

    public void setDelimiter(char delimiter) {
        this.ensureOpen();
        this.delimiter = delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrdinal(CategoryPath categoryPath) throws IOException {
        this.ensureOpen();
        if (categoryPath.length() == 0) {
            return 0;
        }
        String path = categoryPath.toString(this.delimiter);
        LRUHashMap<String, Integer> lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            Integer res = (Integer)this.ordinalCache.get(path);
            if (res != null) {
                return res;
            }
        }
        int ret = -1;
        try {
            this.indexReaderLock.readLock().lock();
            TermDocs docs = this.indexReader.termDocs(Consts.FULL_TERM.createTerm(path));
            if (docs.next()) {
                ret = docs.doc();
            }
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
        LRUHashMap<String, Integer> lRUHashMap2 = this.ordinalCache;
        synchronized (lRUHashMap2) {
            this.ordinalCache.put(path, ret);
        }
        return ret;
    }

    @Override
    public CategoryPath getPath(int ordinal) throws CorruptIndexException, IOException {
        this.ensureOpen();
        String label = this.getLabel(ordinal);
        if (label == null) {
            return null;
        }
        return new CategoryPath(label, this.delimiter);
    }

    @Override
    public boolean getPath(int ordinal, CategoryPath result) throws CorruptIndexException, IOException {
        this.ensureOpen();
        String label = this.getLabel(ordinal);
        if (label == null) {
            return false;
        }
        result.clear();
        result.add(label, this.delimiter);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLabel(int catID) throws CorruptIndexException, IOException {
        String ret;
        LRUHashMap<Integer, String> lRUHashMap;
        this.ensureOpen();
        Integer catIDInteger = catID;
        LRUHashMap<Integer, String> lRUHashMap2 = this.categoryCache;
        synchronized (lRUHashMap2) {
            String res = (String)this.categoryCache.get(catIDInteger);
            if (res != null) {
                return res;
            }
        }
        try {
            this.indexReaderLock.readLock().lock();
            if (catID < 0 || catID >= this.indexReader.maxDoc()) {
                lRUHashMap = null;
                return lRUHashMap;
            }
            ret = this.indexReader.document(catID, Consts.fullPathSelector).get("$full_path$");
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
        lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            this.categoryCache.put(catIDInteger, ret);
        }
        return ret;
    }

    @Override
    public int getParent(int ordinal) {
        this.ensureOpen();
        return this.getParentArray()[ordinal];
    }

    @Override
    public int[] getParentArray() {
        this.ensureOpen();
        return this.parentArray.getArray();
    }

    @Override
    public synchronized boolean refresh() throws IOException, InconsistentTaxonomyException {
        this.ensureOpen();
        IndexReader r2 = IndexReader.openIfChanged((IndexReader)this.indexReader);
        if (r2 == null) {
            return false;
        }
        String t1 = (String)this.indexReader.getIndexCommit().getUserData().get("index.create.time");
        String t2 = (String)r2.getIndexCommit().getUserData().get("index.create.time");
        if (t1 == null) {
            if (t2 != null) {
                r2.close();
                throw new InconsistentTaxonomyException("Taxonomy was recreated at: " + t2);
            }
        } else if (!t1.equals(t2)) {
            r2.close();
            throw new InconsistentTaxonomyException("Taxonomy was recreated at: " + t2 + "  !=  " + t1);
        }
        IndexReader oldreader = this.indexReader;
        this.indexReaderLock.writeLock().lock();
        this.indexReader = r2;
        this.indexReaderLock.writeLock().unlock();
        oldreader.close();
        this.parentArray.refresh(this.indexReader);
        Iterator i = this.ordinalCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if ((Integer)e.getValue() != -1) continue;
            i.remove();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            DirectoryTaxonomyReader directoryTaxonomyReader = this;
            synchronized (directoryTaxonomyReader) {
                if (!this.closed) {
                    this.decRef();
                    this.closed = true;
                }
            }
        }
    }

    private void doClose() throws IOException {
        this.indexReader.close();
        this.closed = true;
        this.parentArray = null;
        this.childrenArrays = null;
        this.categoryCache.clear();
        this.ordinalCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.ensureOpen();
        this.indexReaderLock.readLock().lock();
        try {
            int n = this.indexReader.numDocs();
            return n;
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, String> getCommitUserData() throws IOException {
        this.ensureOpen();
        return this.indexReader.getIndexCommit().getUserData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaxonomyReader.ChildrenArrays getChildrenArrays() {
        this.ensureOpen();
        Object object = this.childrenArraysRebuild;
        synchronized (object) {
            int i;
            int num = this.getSize();
            int first = this.childrenArrays == null ? 0 : this.childrenArrays.getYoungestChildArray().length;
            if (first == num) {
                return this.childrenArrays;
            }
            int[] newYoungestChildArray = new int[num];
            int[] newOlderSiblingArray = new int[num];
            if (this.childrenArrays != null) {
                System.arraycopy(this.childrenArrays.getYoungestChildArray(), 0, newYoungestChildArray, 0, this.childrenArrays.getYoungestChildArray().length);
                System.arraycopy(this.childrenArrays.getOlderSiblingArray(), 0, newOlderSiblingArray, 0, this.childrenArrays.getOlderSiblingArray().length);
            }
            int[] parents = this.getParentArray();
            for (i = first; i < num; ++i) {
                newYoungestChildArray[i] = -1;
            }
            if (first == 0) {
                first = 1;
                newOlderSiblingArray[0] = -1;
            }
            for (i = first; i < num; ++i) {
                newOlderSiblingArray[i] = newYoungestChildArray[parents[i]];
                newYoungestChildArray[parents[i]] = i;
            }
            this.childrenArrays = new ChildrenArraysImpl(newYoungestChildArray, newOlderSiblingArray);
            return this.childrenArrays;
        }
    }

    public String toString(int max) {
        this.ensureOpen();
        StringBuilder sb = new StringBuilder();
        int upperl = Math.min(max, this.indexReader.maxDoc());
        for (int i = 0; i < upperl; ++i) {
            try {
                CategoryPath category = this.getPath(i);
                if (category == null) {
                    sb.append(i + ": NULL!! \n");
                    continue;
                }
                if (category.length() == 0) {
                    sb.append(i + ": EMPTY STRING!! \n");
                    continue;
                }
                sb.append(i + ": " + category.toString() + "\n");
                continue;
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    IndexReader getInternalIndexReader() {
        this.ensureOpen();
        return this.indexReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decRef() throws IOException {
        this.ensureOpen();
        int rc = this.refCount.decrementAndGet();
        if (rc == 0) {
            boolean success = false;
            try {
                this.doClose();
                success = true;
            }
            finally {
                if (!success) {
                    this.refCount.incrementAndGet();
                }
            }
        } else if (rc < 0) {
            throw new IllegalStateException("too many decRef calls: refCount is " + rc + " after decrement");
        }
    }

    @Override
    public int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public void incRef() {
        this.ensureOpen();
        this.refCount.incrementAndGet();
    }

    private static final class ChildrenArraysImpl
    implements TaxonomyReader.ChildrenArrays {
        private int[] youngestChildArray;
        private int[] olderSiblingArray;

        public ChildrenArraysImpl(int[] youngestChildArray, int[] olderSiblingArray) {
            this.youngestChildArray = youngestChildArray;
            this.olderSiblingArray = olderSiblingArray;
        }

        @Override
        public int[] getOlderSiblingArray() {
            return this.olderSiblingArray;
        }

        @Override
        public int[] getYoungestChildArray() {
            return this.youngestChildArray;
        }
    }
}

