/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Vint8 {
    public static final int MAXIMUM_BYTES_NEEDED = 5;

    public static int bytesNeeded(int number) {
        if ((number & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((number & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((number & 0xFFE00000) == 0) {
            return 3;
        }
        if ((number & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static void encode(int number, OutputStream out) throws IOException {
        if ((number & 0xFFFFFF80) == 0) {
            out.write(number);
        } else if ((number & 0xFFFFC000) == 0) {
            out.write(0x80 | number >> 7);
            out.write(0x7F & number);
        } else if ((number & 0xFFE00000) == 0) {
            out.write(0x80 | number >> 14);
            out.write(0x80 | number >> 7);
            out.write(0x7F & number);
        } else if ((number & 0xF0000000) == 0) {
            out.write(0x80 | number >> 21);
            out.write(0x80 | number >> 14);
            out.write(0x80 | number >> 7);
            out.write(0x7F & number);
        } else {
            out.write(0x80 | number >> 28);
            out.write(0x80 | number >> 21);
            out.write(0x80 | number >> 14);
            out.write(0x80 | number >> 7);
            out.write(0x7F & number);
        }
    }

    public static int encode(int number, byte[] dest, int start) {
        if ((number & 0xFFFFFF80) == 0) {
            dest[start] = (byte)number;
            return 1;
        }
        if ((number & 0xFFFFC000) == 0) {
            dest[start] = (byte)(0x80 | (number & 0x3F80) >> 7);
            dest[start + 1] = (byte)(number & 0x7F);
            return 2;
        }
        if ((number & 0xFFE00000) == 0) {
            dest[start] = (byte)(0x80 | (number & 0x1FC000) >> 14);
            dest[start + 1] = (byte)(0x80 | (number & 0x3F80) >> 7);
            dest[start + 2] = (byte)(number & 0x7F);
            return 3;
        }
        if ((number & 0xF0000000) == 0) {
            dest[start] = (byte)(0x80 | (number & 0xFE00000) >> 21);
            dest[start + 1] = (byte)(0x80 | (number & 0x1FC000) >> 14);
            dest[start + 2] = (byte)(0x80 | (number & 0x3F80) >> 7);
            dest[start + 3] = (byte)(number & 0x7F);
            return 4;
        }
        dest[start] = (byte)(0x80 | (number & 0xF0000000) >> 28);
        dest[start + 1] = (byte)(0x80 | (number & 0xFE00000) >> 21);
        dest[start + 2] = (byte)(0x80 | (number & 0x1FC000) >> 14);
        dest[start + 3] = (byte)(0x80 | (number & 0x3F80) >> 7);
        dest[start + 4] = (byte)(number & 0x7F);
        return 5;
    }

    public static int decode(byte[] bytes, Position pos) {
        int value = 0;
        while (true) {
            byte first = bytes[pos.pos];
            ++pos.pos;
            value |= first & 0x7F;
            if ((first & 0x80) == 0) {
                return value;
            }
            value <<= 7;
        }
    }

    public static int decode(InputStream in) throws IOException {
        int value = 0;
        while (true) {
            int first;
            if ((first = in.read()) < 0) {
                throw new EOFException();
            }
            value |= first & 0x7F;
            if ((first & 0x80) == 0) {
                return value;
            }
            value <<= 7;
        }
    }

    private Vint8() {
    }

    public static class Position {
        public int pos;

        public Position() {
        }

        public Position(int initialPosition) {
            this.pos = initialPosition;
        }
    }
}

