/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.collections;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.util.collections.IntIterator;

public class ArrayHashMap<K, V>
implements Iterable<V> {
    private static final int DEFAULT_CAPACITY = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    Object[] keys;
    int[] next;
    private int prev;
    private int size;
    Object[] values;

    public ArrayHashMap() {
        this(16);
    }

    public ArrayHashMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new Object[arrayLength];
        this.keys = new Object[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(K key, V value) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = value;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(K key) {
        return key.hashCode() & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(K key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(Object o) {
        for (V object : this) {
            if (!object.equals(o)) continue;
            return true;
        }
        return false;
    }

    protected int find(K key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex].equals(key)) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(K key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index].equals(key)) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public V get(K key) {
        return (V)this.values[this.find(key)];
    }

    protected void grow() {
        ArrayHashMap<K, V> newmap = new ArrayHashMap<K, V>(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            super.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = newmap.capacity;
        this.size = newmap.size;
        this.firstEmpty = newmap.firstEmpty;
        this.values = newmap.values;
        this.keys = newmap.keys;
        this.next = newmap.next;
        this.baseHash = newmap.baseHash;
        this.hashFactor = newmap.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator();
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    private void printBaseHash() {
        for (int i : this.baseHash) {
            System.out.println(i + ".\t" + i);
        }
    }

    public V put(K key, V e) {
        int index = this.find(key);
        if (index != 0) {
            Object old = this.values[index];
            this.values[index] = e;
            return (V)old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, e);
        return null;
    }

    public V remove(K key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return (V)this.values[index];
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        int j = -1;
        Object[] array = new Object[this.size];
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public V[] toArray(V[] a) {
        int j;
        Iterator<V> iterator = this.iterator();
        for (j = 0; j < a.length && iterator.hasNext(); ++j) {
            a[j] = iterator.next();
        }
        if (j < a.length) {
            a[j] = null;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator<K> keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            K key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        ArrayHashMap that = (ArrayHashMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        Iterator<K> it = this.keyIterator();
        while (it.hasNext()) {
            K key = it.next();
            V v1 = this.get(key);
            V v2 = that.get(key);
            if (!(v1 == null && v2 != null || v1 != null && v2 == null) && v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements Iterator<V> {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return ArrayHashMap.this.values[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements Iterator<K> {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return ArrayHashMap.this.keys[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < ArrayHashMap.this.baseHash.length) {
                this.index = ArrayHashMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index != 0;
        }

        @Override
        public int next() {
            this.lastIndex = this.index;
            this.index = ArrayHashMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < ArrayHashMap.this.baseHash.length) {
                this.index = ArrayHashMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        @Override
        public void remove() {
            ArrayHashMap.this.remove(ArrayHashMap.this.keys[this.lastIndex]);
        }
    }
}

