/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import org.apache.lucene.util.encoding.ChunksIntEncoder;
import org.apache.lucene.util.encoding.FourFlagsIntDecoder;
import org.apache.lucene.util.encoding.IntDecoder;

public class FourFlagsIntEncoder
extends ChunksIntEncoder {
    private static byte[][] encodeTable = new byte[][]{{0, 0, 0, 0}, {1, 4, 16, 64}, {2, 8, 32, -128}, {3, 12, 48, -64}};

    public FourFlagsIntEncoder() {
        super(4);
    }

    @Override
    public void encode(int data) throws IOException {
        if (data <= 3) {
            this.indicator |= encodeTable[data][this.ordinal];
        } else {
            this.encodeQueue[this.encodeQueueSize++] = data - 4;
        }
        this.ordinal = (byte)(this.ordinal + 1);
        if ((this.ordinal & 3) == 0) {
            this.encodeChunk();
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new FourFlagsIntDecoder();
    }

    public String toString() {
        return "FourFlags (" + this.encoder.toString() + ")";
    }
}

