/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.IntEncoderFilter;

public final class UniqueValuesIntEncoder
extends IntEncoderFilter {
    private static final long ILLEGAL_VALUE = Integer.MIN_VALUE;
    private long prev = Integer.MIN_VALUE;

    public UniqueValuesIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    @Override
    public void encode(int value) throws IOException {
        if (this.prev != (long)value) {
            this.encoder.encode(value);
            this.prev = value;
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return this.encoder.createMatchingDecoder();
    }

    @Override
    public void reInit(OutputStream out) {
        super.reInit(out);
        this.prev = Integer.MIN_VALUE;
    }

    public String toString() {
        return "Unique (" + this.encoder.toString() + ")";
    }
}

