/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import org.apache.lucene.util.encoding.IntDecoder;

public class VInt8IntDecoder
extends IntDecoder {
    private boolean legalEOS = true;

    @Override
    public long decode() throws IOException {
        int value = 0;
        while (true) {
            int first;
            if ((first = this.in.read()) < 0) {
                if (!this.legalEOS) {
                    throw new IOException("Unexpected End-Of-Stream");
                }
                return 0x100000000L;
            }
            value |= first & 0x7F;
            if ((first & 0x80) == 0) {
                this.legalEOS = true;
                return value;
            }
            this.legalEOS = false;
            value <<= 7;
        }
    }

    public String toString() {
        return "VInt8";
    }
}

