/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.annotation.CompressionHint;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.InvocationCancellationMessageWriter;
import org.jboss.ejb.client.remoting.MethodInvocationMessageWriter;
import org.jboss.ejb.client.remoting.ModuleAvailabilityMessageHandler;
import org.jboss.ejb.client.remoting.NoFlushDataOutputStream;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.SessionOpenRequestWriter;
import org.jboss.ejb.client.remoting.SessionOpenResponseHandler;
import org.jboss.ejb.client.remoting.TransactionMessageWriter;
import org.jboss.ejb.client.remoting.VersionReceiver;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public final class RemotingConnectionEJBReceiver
extends EJBReceiver {
    private static final Logger logger = Logger.getLogger(RemotingConnectionEJBReceiver.class);
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    private final Connection connection;
    private final Map<EJBReceiverContext, ChannelAssociation> channelAssociations = new IdentityHashMap<EJBReceiverContext, ChannelAssociation>();
    private final Map<EJBReceiverContext, CountDownLatch> moduleAvailabilityReportLatches = new IdentityHashMap<EJBReceiverContext, CountDownLatch>();
    private final MarshallerFactory marshallerFactory;
    private final ReconnectHandler reconnectHandler;
    private final OptionMap channelCreationOptions;

    public RemotingConnectionEJBReceiver(Connection connection) {
        this(connection, null, OptionMap.EMPTY);
    }

    public RemotingConnectionEJBReceiver(Connection connection, ReconnectHandler reconnectHandler, OptionMap channelCreationOptions) {
        super(connection.getRemoteEndpointName());
        this.connection = connection;
        this.reconnectHandler = reconnectHandler;
        this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        this.marshallerFactory = Marshalling.getProvidedMarshallerFactory("river");
        if (this.marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for 'river' marshalling strategy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associate(EJBReceiverContext context) {
        boolean successfulHandshake;
        CountDownLatch initialModuleAvailabilityLatch;
        block14: {
            CountDownLatch versionHandshakeLatch = new CountDownLatch(1);
            initialModuleAvailabilityLatch = new CountDownLatch(1);
            Map<EJBReceiverContext, CountDownLatch> map = this.moduleAvailabilityReportLatches;
            synchronized (map) {
                this.moduleAvailabilityReportLatches.put(context, initialModuleAvailabilityLatch);
            }
            final VersionReceiver versionReceiver = new VersionReceiver(versionHandshakeLatch);
            IoFuture<Channel> futureChannel = this.connection.openChannel(EJB_CHANNEL_NAME, this.channelCreationOptions);
            futureChannel.addNotifier(new IoFuture.HandlingNotifier<Channel, EJBReceiverContext>(){

                @Override
                public void handleCancelled(EJBReceiverContext context) {
                    logger.debug("Channel open requested cancelled for context " + context);
                    context.close();
                }

                @Override
                public void handleFailed(IOException exception, EJBReceiverContext context) {
                    logger.error((Object)("Failed to open channel for context " + context), exception);
                    context.close();
                }

                @Override
                public void handleDone(Channel channel, final EJBReceiverContext context) {
                    channel.addCloseHandler(new CloseHandler<Channel>(){

                        @Override
                        public void handleClose(Channel closed, IOException exception) {
                            logger.debug((Object)("Closing channel" + closed), exception);
                            context.close();
                        }
                    });
                    logger.debug("Channel " + channel + " opened for context " + context + " Waiting for version handshake message from server");
                    channel.receiveMessage(versionReceiver);
                }
            }, context);
            successfulHandshake = false;
            try {
                EJBClientConfiguration ejbClientConfiguration = context.getClientContext().getEJBClientConfiguration();
                long versionHandshakeTimeoutInMillis = ejbClientConfiguration == null || ejbClientConfiguration.getInvocationTimeout() <= 0L ? 5000L : ejbClientConfiguration.getInvocationTimeout();
                successfulHandshake = versionHandshakeLatch.await(versionHandshakeTimeoutInMillis, TimeUnit.MILLISECONDS);
                if (successfulHandshake) {
                    Channel compatibleChannel = versionReceiver.getCompatibleChannel();
                    ChannelAssociation channelAssociation = new ChannelAssociation(this, context, compatibleChannel, (byte)versionReceiver.getNegotiatedProtocolVersion(), this.marshallerFactory, this.reconnectHandler);
                    Map<EJBReceiverContext, ChannelAssociation> map2 = this.channelAssociations;
                    synchronized (map2) {
                        this.channelAssociations.put(context, channelAssociation);
                    }
                    Logs.REMOTING.successfulVersionHandshake(context, compatibleChannel);
                    break block14;
                }
                Logs.REMOTING.versionHandshakeNotCompleted(context);
                context.close();
                if (this.reconnectHandler != null && !versionReceiver.failedCompatibility()) {
                    logger.debug("Adding reconnect handler to client context " + context.getClientContext());
                    context.getClientContext().registerReconnectHandler(this.reconnectHandler);
                }
            }
            catch (InterruptedException e) {
                context.close();
            }
        }
        if (successfulHandshake) {
            try {
                boolean initialReportAvailable = initialModuleAvailabilityLatch.await(5L, TimeUnit.SECONDS);
                if (!initialReportAvailable) {
                    Logs.REMOTING.initialModuleAvailabilityReportNotReceived(this);
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)("Caught InterruptedException while waiting for initial module availability report for " + this), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disassociate(EJBReceiverContext context) {
        ChannelAssociation channelAssociation = null;
        Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociations;
        synchronized (map) {
            channelAssociation = this.channelAssociations.remove(context);
        }
        if (channelAssociation != null) {
            try {
                channelAssociation.getChannel().close();
            }
            catch (IOException e) {
                logger.warn((Object)("Caught IOException when trying to close channel: " + channelAssociation.getChannel()), e);
            }
        }
    }

    @Override
    public void processInvocation(final EJBClientInvocationContext clientInvocationContext, final EJBReceiverInvocationContext ejbReceiverInvocationContext) throws Exception {
        if (System.getSecurityManager() == null) {
            this.processInvocationInternal(clientInvocationContext, ejbReceiverInvocationContext);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        RemotingConnectionEJBReceiver.this.processInvocationInternal(clientInvocationContext, ejbReceiverInvocationContext);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processInvocationInternal(EJBClientInvocationContext clientInvocationContext, EJBReceiverInvocationContext ejbReceiverInvocationContext) throws Exception {
        ChannelAssociation channelAssociation = null;
        FilterOutputStream dataOutputStream = null;
        MessageOutputStream messageOutputStream = null;
        Throwable requestSendFailureCause = null;
        channelAssociation = this.requireChannelAssociation(ejbReceiverInvocationContext.getEjbReceiverContext());
        MethodInvocationMessageWriter messageWriter = new MethodInvocationMessageWriter(this.marshallerFactory);
        messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        dataOutputStream = this.wrapMessageOutputStream(clientInvocationContext, channelAssociation, messageOutputStream);
        short invocationId = channelAssociation.getNextInvocationId();
        channelAssociation.receiveResponse(invocationId, ejbReceiverInvocationContext);
        messageWriter.writeMessage((DataOutput)((Object)dataOutputStream), invocationId, clientInvocationContext);
        try {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
            if (channelAssociation == null || messageOutputStream == null) return;
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            return;
        }
        finally {
            if (requestSendFailureCause != null) {
                throw new RequestSendFailedException(ejbReceiverInvocationContext.getNodeName(), requestSendFailureCause.getMessage(), requestSendFailureCause);
            }
        }
        catch (Throwable t) {
            try {
                requestSendFailureCause = t;
            }
            catch (Throwable throwable) {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                    if (channelAssociation == null || messageOutputStream == null) throw throwable;
                    channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                    throw throwable;
                }
                finally {
                    if (requestSendFailureCause != null) {
                        throw new RequestSendFailedException(ejbReceiverInvocationContext.getNodeName(), requestSendFailureCause.getMessage(), requestSendFailureCause);
                    }
                }
            }
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (channelAssociation != null) {
                    if (messageOutputStream != null) {
                        channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                    }
                }
            }
            finally {
                if (requestSendFailureCause == null) return;
                throw new RequestSendFailedException(ejbReceiverInvocationContext.getNodeName(), requestSendFailureCause.getMessage(), requestSendFailureCause);
            }
        }
    }

    @Override
    protected <T> StatefulEJBLocator<T> openSession(EJBReceiverContext receiverContext, Class<T> viewType, String appName, String moduleName, String distinctName, String beanName) throws IllegalArgumentException {
        SessionOpenResponseHandler.SessionOpenResponse sessionOpenResponse;
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer;
        NoFlushDataOutputStream dataOutputStream;
        MessageOutputStream messageOutputStream;
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        SessionOpenRequestWriter sessionOpenRequestWriter = new SessionOpenRequestWriter();
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            short invocationId = channelAssociation.getNextInvocationId();
            futureResultProducer = channelAssociation.enrollForResult(invocationId);
            sessionOpenRequestWriter.writeMessage(dataOutputStream, invocationId, appName, moduleName, distinctName, beanName);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        EJBClientConfiguration ejbClientConfiguration = receiverContext.getClientContext().getEJBClientConfiguration();
        long invocationTimeout = ejbClientConfiguration == null ? 0L : ejbClientConfiguration.getInvocationTimeout();
        try {
            resultProducer = invocationTimeout <= 0L ? futureResultProducer.get() : futureResultProducer.get(invocationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            sessionOpenResponse = (SessionOpenResponseHandler.SessionOpenResponse)resultProducer.getResult();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new StatefulEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, sessionOpenResponse.getSessionID(), sessionOpenResponse.getAffinity(), this.getNodeName());
    }

    @Override
    public boolean exists(String appName, String moduleName, String distinctName, String beanName) {
        logger.warn("Not yet implemented RemotingConnectionEJBReceiver#verify");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendCommit(EJBReceiverContext receiverContext, TransactionID transactionID, boolean onePhase) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            TransactionMessageWriter transactionMessageWriter = TransactionMessageWriter.getTransactionCommitWriter();
            try {
                transactionMessageWriter.writeTxCommit(dataOutputStream, invocationId, transactionID, onePhase);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction commit message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendRollback(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            TransactionMessageWriter transactionMessageWriter = TransactionMessageWriter.getTransactionRollbackWriter();
            try {
                transactionMessageWriter.writeTxRollback(dataOutputStream, invocationId, transactionID);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction rollback message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int sendPrepare(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            TransactionMessageWriter transactionMessageWriter = TransactionMessageWriter.getTransactionPrepareWriter();
            try {
                transactionMessageWriter.writeTxPrepare(dataOutputStream, invocationId, transactionID);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction prepare message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            Object result = resultProducer.getResult();
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new RuntimeException("Unexpected result for transaction prepare: " + result);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendForget(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            TransactionMessageWriter transactionMessageWriter = TransactionMessageWriter.getTransactionForgetWriter();
            try {
                transactionMessageWriter.writeTxForget(dataOutputStream, invocationId, transactionID);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction forget message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Xid[] sendRecover(EJBReceiverContext receiverContext, String txParentNodeName, int recoveryFlags) throws XAException {
        TransactionMessageWriter transactionMessageWriter;
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        if (!channelAssociation.isMessageCompatibleForNegotiatedProtocolVersion((transactionMessageWriter = TransactionMessageWriter.getTransactionRecoverWriter()).getHeader())) {
            Logs.REMOTING.transactionRecoveryMessageNotSupported(receiverContext.getReceiver());
            return new Xid[0];
        }
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            try {
                transactionMessageWriter.writeTxRecover(dataOutputStream, invocationId, txParentNodeName, recoveryFlags);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction recover message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            Object result = resultProducer.getResult();
            if (result instanceof Xid[]) {
                return (Xid[])result;
            }
            throw new RuntimeException("Unexpected result for transaction recover: " + result);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeCompletion(EJBReceiverContext receiverContext, TransactionID transactionID) {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            TransactionMessageWriter transactionMessageWriter = TransactionMessageWriter.getTransactionBeforeCompletionWriter();
            try {
                transactionMessageWriter.writeTxBeforeCompletion(dataOutputStream, invocationId, transactionID);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending transaction beforeCompletion message", e);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelInvocation(EJBClientInvocationContext clientInvocationContext, EJBReceiverInvocationContext receiverInvocationContext) {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverInvocationContext.getEjbReceiverContext());
        Short priorInvocationId = channelAssociation.getInvocationId(receiverInvocationContext);
        if (priorInvocationId == null) {
            return false;
        }
        try {
            MessageOutputStream messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
            NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream(messageOutputStream);
            InvocationCancellationMessageWriter invocationCancellationMessageWriter = new InvocationCancellationMessageWriter();
            try {
                invocationCancellationMessageWriter.writeMessage(dataOutputStream, priorInvocationId);
            }
            finally {
                channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                ((FilterOutputStream)dataOutputStream).close();
            }
        }
        catch (Exception e) {
            Logs.REMOTING.failedToSendInvocationCancellationMessage(priorInvocationId, e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modulesAvailable(EJBReceiverContext receiverContext, ModuleAvailabilityMessageHandler.EJBModuleIdentifier[] ejbModules) {
        CountDownLatch moduleAvailabilityReportLatch;
        logger.debug("Received module availability report for " + ejbModules.length + " modules");
        for (ModuleAvailabilityMessageHandler.EJBModuleIdentifier moduleIdentifier : ejbModules) {
            logger.debug("Registering module " + moduleIdentifier + " availability for receiver context " + receiverContext);
            this.registerModule(moduleIdentifier.appName, moduleIdentifier.moduleName, moduleIdentifier.distinctName);
        }
        Map<EJBReceiverContext, CountDownLatch> map = this.moduleAvailabilityReportLatches;
        synchronized (map) {
            moduleAvailabilityReportLatch = this.moduleAvailabilityReportLatches.remove(receiverContext);
        }
        if (moduleAvailabilityReportLatch != null) {
            moduleAvailabilityReportLatch.countDown();
        }
    }

    void modulesUnavailable(EJBReceiverContext receiverContext, ModuleAvailabilityMessageHandler.EJBModuleIdentifier[] ejbModules) {
        logger.debug("Received module un-availability report for " + ejbModules.length + " modules");
        for (ModuleAvailabilityMessageHandler.EJBModuleIdentifier moduleIdentifier : ejbModules) {
            logger.debug("Un-registering module " + moduleIdentifier + " from receiver context " + receiverContext);
            this.deregisterModule(moduleIdentifier.appName, moduleIdentifier.moduleName, moduleIdentifier.distinctName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelAssociation requireChannelAssociation(EJBReceiverContext ejbReceiverContext) {
        ChannelAssociation channelAssociation;
        Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociations;
        synchronized (map) {
            channelAssociation = this.channelAssociations.get(ejbReceiverContext);
        }
        if (channelAssociation == null) {
            throw Logs.MAIN.channelNotReadyForCommunication(EJB_CHANNEL_NAME, ejbReceiverContext);
        }
        return channelAssociation;
    }

    private DataOutputStream wrapMessageOutputStream(EJBClientInvocationContext invocationContext, ChannelAssociation channelAssociation, MessageOutputStream messageOutputStream) throws Exception {
        CompressionHint compressionHintOnMethod;
        if (channelAssociation.getNegotiatedProtocolVersion() < 2) {
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot send compressed data messages to server because the negotiated protocol version " + channelAssociation.getNegotiatedProtocolVersion() + " doesn't support compressed messages. Going to send uncompressed message");
            }
            return new NoFlushDataOutputStream(messageOutputStream);
        }
        Boolean hintsDisabled = invocationContext.getProxyAttachment(AttachmentKeys.HINTS_DISABLED);
        if (hintsDisabled != null && hintsDisabled.booleanValue()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Hints are disabled. Ignoring any CompressionHint on methods being invoked on view " + invocationContext.getViewClass());
            }
            return new NoFlushDataOutputStream(messageOutputStream);
        }
        Map<Method, CompressionHint> dataCompressionHintMethods = invocationContext.getProxyAttachment(AttachmentKeys.VIEW_METHOD_DATA_COMPRESSION_HINT_ATTACHMENT_KEY);
        CompressionHint compressionHint = dataCompressionHintMethods == null || dataCompressionHintMethods.isEmpty() ? invocationContext.getProxyAttachment(AttachmentKeys.VIEW_CLASS_DATA_COMPRESSION_HINT_ATTACHMENT_KEY) : ((compressionHintOnMethod = dataCompressionHintMethods.get(invocationContext.getInvokedMethod())) == null ? invocationContext.getProxyAttachment(AttachmentKeys.VIEW_CLASS_DATA_COMPRESSION_HINT_ATTACHMENT_KEY) : compressionHintOnMethod);
        if (compressionHint == null) {
            return new NoFlushDataOutputStream(messageOutputStream);
        }
        int compressionLevel = compressionHint.compressionLevel();
        if (compressionHint.compressResponse()) {
            invocationContext.putAttachment(AttachmentKeys.COMPRESS_RESPONSE, true);
            invocationContext.putAttachment(AttachmentKeys.RESPONSE_COMPRESSION_LEVEL, compressionLevel);
            if (logger.isTraceEnabled()) {
                logger.trace("Letting the server know that the response of method " + invocationContext.getInvokedMethod() + " has to be compressed with compression level = " + compressionLevel);
            }
        }
        if (compressionHint.compressRequest()) {
            messageOutputStream.write(27);
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)messageOutputStream, deflater);
            if (logger.isTraceEnabled()) {
                logger.trace("Using a compressing stream with compression level = " + compressionLevel + " for request data for EJB invocation on method " + invocationContext.getInvokedMethod());
            }
            return new NoFlushDataOutputStream(deflaterOutputStream);
        }
        return new NoFlushDataOutputStream(messageOutputStream);
    }

    public String toString() {
        return String.format("Remoting connection EJB receiver [connection=%s,channel=%s,nodename=%s]", this.connection, EJB_CHANNEL_NAME, this.getNodeName());
    }
}

