/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.WritableNamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.as.naming.util.ThreadLocalStack;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class WritableServiceBasedNamingStore
extends ServiceBasedNamingStore
implements WritableNamingStore {
    private static final ThreadLocalStack<ServiceName> WRITE_OWNER = new ThreadLocalStack();
    private final ServiceTarget serviceTarget;

    public WritableServiceBasedNamingStore(ServiceRegistry serviceRegistry, ServiceName serviceNameBase, ServiceTarget serviceTarget) {
        super(serviceRegistry, serviceNameBase);
        this.serviceTarget = serviceTarget;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        ServiceName deploymentUnitServiceName = this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        this.bind(name, bindName, object, deploymentUnitServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(Name name, ServiceName bindName, Object object, ServiceName deploymentUnitServiceName) throws NamingException {
        try {
            BinderService binderService = new BinderService(name.toString(), null, deploymentUnitServiceName);
            ServiceBuilder builder = this.serviceTarget.addService(bindName, (Service)binderService).addDependency(this.getServiceNameBase(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory((Value<?>)new ImmediateValue(object))).setInitialMode(ServiceController.Mode.ACTIVE);
            ServiceController binderServiceController = builder.install();
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(binderServiceController);
            try {
                monitor.awaitStability();
            }
            finally {
                monitor.removeController(binderServiceController);
            }
            StartException startException = binderServiceController.getStartException();
            if (startException != null) {
                throw startException;
            }
            binderService.acquire();
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to bind [" + object + "] at location [" + bindName + "]", e);
        }
    }

    @Override
    public void bind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.bind(name, object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        ServiceName deploymentUnitServiceName = this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        try {
            this.unbind(name, bindName);
        }
        catch (NamingException ignore) {
            // empty catch block
        }
        this.bind(name, bindName, object, deploymentUnitServiceName);
    }

    @Override
    public void rebind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.rebind(name, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        this.unbind(name, bindName);
    }

    private void unbind(Name name, ServiceName bindName) throws NamingException {
        ServiceController controller = this.getServiceRegistry().getService(bindName);
        if (controller == null) {
            throw NamingMessages.MESSAGES.cannotResolveService(bindName);
        }
        controller.setMode(ServiceController.Mode.REMOVE);
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            monitor.awaitStability();
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to unbind [" + bindName + "]", e);
        }
        finally {
            monitor.removeController(controller);
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.requireOwner();
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingMessages.MESSAGES.emptyNameNotAllowed();
        }
        return new NamingContext(name, this, new Hashtable());
    }

    private ServiceName requireOwner() {
        ServiceName owner = WRITE_OWNER.peek();
        if (owner == null) {
            throw NamingMessages.MESSAGES.readOnlyNamingContext();
        }
        return owner;
    }

    public static void pushOwner(ServiceName du) {
        WRITE_OWNER.push(du);
    }

    public static void popOwner() {
        WRITE_OWNER.pop();
    }
}

