/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.as.clustering.jgroups.LogFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemDescribe;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResource;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResource;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResource;
import org.jboss.as.clustering.jgroups.subsystem.StackResource;
import org.jboss.as.clustering.jgroups.subsystem.TransportResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JGroupsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jgroups";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jgroups");
    public static final String RESOURCE_NAME = JGroupsExtension.class.getPackage().getName() + "." + "LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 3;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JGroupsExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 3, 0);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new JGroupsSubsystemRootResource());
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)JGroupsSubsystemDescribe.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)new StackResource(registerRuntimeOnly));
        registration.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            JGroupsExtension.registerTransformers(registration);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    private static void registerTransformers(SubsystemRegistration subsystem) {
        ModelVersion version110 = ModelVersion.create((int)1, (int)1, (int)0);
        RejectExpressionValuesTransformer TRANSFORMER = new RejectExpressionValuesTransformer(new AttributeDefinition[]{PropertyResource.VALUE, TransportResource.PROPERTIES, ProtocolResource.PROPERTIES, TransportResource.SHARED});
        TransformersSubRegistration registration = subsystem.registerModelTransformers((ModelVersionRange)version110, ResourceTransformer.DEFAULT);
        TransformersSubRegistration stack = registration.registerSubResource(StackResource.STACK_PATH);
        TransformersSubRegistration transport = stack.registerSubResource(TransportResource.TRANSPORT_PATH, (ResourceTransformer)TRANSFORMER);
        transport.registerOperationTransformer("add", (OperationTransformer)TRANSFORMER);
        transport.registerOperationTransformer("write-attribute", TRANSFORMER.getWriteAttributeTransformer());
        TransformersSubRegistration transport_property = transport.registerSubResource(PropertyResource.PROPERTY_PATH);
        transport_property.registerOperationTransformer("add", (OperationTransformer)TRANSFORMER);
        transport_property.registerOperationTransformer("write-attribute", TRANSFORMER.getWriteAttributeTransformer());
        TransformersSubRegistration protocol = stack.registerSubResource(ProtocolResource.PROTOCOL_PATH, (ResourceTransformer)TRANSFORMER);
        protocol.registerOperationTransformer("add", (OperationTransformer)TRANSFORMER);
        TransformersSubRegistration protocol_property = protocol.registerSubResource(PropertyResource.PROPERTY_PATH);
        protocol_property.registerOperationTransformer("add", (OperationTransformer)TRANSFORMER);
        protocol_property.registerOperationTransformer("write-attribute", TRANSFORMER.getWriteAttributeTransformer());
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("jgroups.logging.log_factory_class") == null) {
                    System.setProperty("jgroups.logging.log_factory_class", LogFactory.class.getName());
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

