/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAResource;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.jca.core.spi.transaction.local.LocalResourceException;

public class LocalManagedConnection
extends BaseWrapperManagedConnection
implements LocalTransaction {
    public LocalManagedConnection(LocalManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        super(mcf, con, props, transactionIsolation, psCacheSize);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new ResourceException("Local tx only!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.inManagedTransaction) {
                    this.inManagedTransaction = false;
                }
            }
            try {
                this.con.commit();
            }
            catch (SQLException e) {
                if (this.mcf.isExceptionFatal(e)) {
                    this.broadcastConnectionError(e);
                    throw new LocalResourceException(e.getMessage(), (Throwable)e);
                }
                this.checkException(e);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.inManagedTransaction) {
                    this.inManagedTransaction = false;
                }
            }
            try {
                this.con.rollback();
            }
            catch (SQLException e) {
                if (this.mcf.isExceptionFatal(e)) {
                    this.broadcastConnectionError(e);
                    throw new LocalResourceException(e.getMessage(), (Throwable)e);
                }
                try {
                    this.checkException(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws ResourceException {
        this.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (!this.inManagedTransaction) {
                    try {
                        if (this.underlyingAutoCommit) {
                            this.underlyingAutoCommit = false;
                            this.con.setAutoCommit(false);
                        }
                        this.checkState();
                        this.inManagedTransaction = true;
                    }
                    catch (SQLException e) {
                        this.checkException(e);
                    }
                } else {
                    throw new ResourceException("Trying to begin a nested local tx");
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isXA() {
        return false;
    }
}

