/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.as.jmx.JmxMessages;

public class BlockingNotificationMBeanServer
implements MBeanServer {
    private MBeanServer mbs;
    private final String resolvedDomain;
    private final String expressionsDomain;
    private final Map<Association, BlockingNotificationFilter> associations = new ConcurrentHashMap<Association, BlockingNotificationFilter>();

    public BlockingNotificationMBeanServer(MBeanServer mbs, String resolvedDomain, String expressionsDomain) {
        this.mbs = mbs;
        this.resolvedDomain = resolvedDomain;
        this.expressionsDomain = expressionsDomain;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.mbs.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbs.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.mbs.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbs.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbs.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbs.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbs.getObjectInstance(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.mbs.queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.mbs.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbs.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbs.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.getAttributes(name, attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbs.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbs.setAttributes(name, attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbs.invoke(name, operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this.mbs.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbs.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        boolean inExposedModelControllerDomains = this.isInExposedModelControllerDomains(name);
        if (inExposedModelControllerDomains) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.addNotificationListenerNotAllowed(name));
        }
        BlockingNotificationFilter blockingFilter = new BlockingNotificationFilter(filter);
        this.associations.put(new Association(name, listener, filter, handback), blockingFilter);
        this.mbs.addNotificationListener(name, listener, (NotificationFilter)blockingFilter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        boolean inExposedModelControllerDomains = this.isInExposedModelControllerDomains(name);
        if (inExposedModelControllerDomains) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.addNotificationListenerNotAllowed(name));
        }
        BlockingNotificationFilter blockingFilter = new BlockingNotificationFilter(filter);
        this.associations.put(new Association(name, listener, filter, handback), blockingFilter);
        this.mbs.addNotificationListener(name, listener, (NotificationFilter)new BlockingNotificationFilter(filter), handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isInExposedModelControllerDomains(name)) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListenerNotAllowed(name));
        }
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isInExposedModelControllerDomains(name)) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListenerNotAllowed(name));
        }
        BlockingNotificationFilter blockingFilter = this.associations.get(new Association(name, listener, filter, handback));
        if (blockingFilter != null) {
            this.mbs.removeNotificationListener(name, listener, (NotificationFilter)blockingFilter, handback);
        } else {
            this.mbs.removeNotificationListener(name, listener, filter, handback);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isInExposedModelControllerDomains(name)) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListenerNotAllowed(name));
        }
        this.mbs.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isInExposedModelControllerDomains(name)) {
            throw new RuntimeOperationsException(JmxMessages.MESSAGES.removeNotificationListenerNotAllowed(name));
        }
        BlockingNotificationFilter blockingFilter = this.associations.get(new Association(name, listener, filter, handback));
        if (blockingFilter != null) {
            this.mbs.removeNotificationListener(name, listener, (NotificationFilter)blockingFilter, handback);
        } else {
            this.mbs.removeNotificationListener(name, listener, filter, handback);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbs.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbs.isInstanceOf(name, className);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbs.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbs.instantiate(className, loaderName, params, signature);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.mbs.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.mbs.deserialize(className, loaderName, data);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbs.getClassLoaderFor(loaderName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mbs.getClassLoaderRepository();
    }

    private boolean isInExposedModelControllerDomains(ObjectName name) {
        String domain = name.getDomain();
        if (!name.isDomainPattern() && (domain.equals(this.resolvedDomain) || domain.equals(this.expressionsDomain))) {
            return true;
        }
        Pattern p = Pattern.compile(name.getDomain().replace("*", ".*"));
        return this.resolvedDomain != null && p.matcher(this.resolvedDomain).matches() || this.expressionsDomain != null && p.matcher(this.expressionsDomain).matches();
    }

    private static final class Association {
        private final ObjectName name;
        private final Object listener;
        private final NotificationFilter filter;
        private final Object handback;

        private Association(ObjectName name, Object listener, NotificationFilter filter, Object handback) {
            this.name = name;
            this.filter = filter;
            this.listener = listener;
            this.handback = handback;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Association that = (Association)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            if (this.handback != null ? !this.handback.equals(that.handback) : that.handback != null) {
                return false;
            }
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.handback != null ? this.handback.hashCode() : 0);
            return result;
        }
    }

    private class BlockingNotificationFilter
    implements NotificationFilter {
        private final NotificationFilter filter;

        private BlockingNotificationFilter(NotificationFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            MBeanServerNotification notif;
            if (notification instanceof MBeanServerNotification && ((notif = (MBeanServerNotification)notification).getMBeanName().getDomain().equals(BlockingNotificationMBeanServer.this.resolvedDomain) || notif.getMBeanName().getDomain().equals(BlockingNotificationMBeanServer.this.expressionsDomain))) {
                return false;
            }
            if (this.filter == null) {
                return true;
            }
            return this.filter.isNotificationEnabled(notification);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockingNotificationFilter that = (BlockingNotificationFilter)o;
            return !(this.filter != null ? !this.filter.equals(that.filter) : that.filter != null);
        }

        public int hashCode() {
            return this.filter != null ? this.filter.hashCode() : 0;
        }
    }
}

