/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

abstract class ExposeModelResource
extends SimpleResourceDefinition {
    private final ManagedAuditLogger auditLoggerInfo;
    private final JmxAuthorizer authorizer;
    private final SimpleAttributeDefinition domainName;

    ExposeModelResource(PathElement pathElement, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, SimpleAttributeDefinition domainName, SimpleAttributeDefinition ... otherAttributes) {
        super(pathElement, JMXExtension.getResourceDescriptionResolver("expose-model." + pathElement.getValue()), (OperationStepHandler)new ShowModelAdd(auditLoggerInfo, authorizer, domainName, otherAttributes), (OperationStepHandler)new ShowModelRemove(auditLoggerInfo, authorizer));
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.domainName = domainName;
    }

    static SimpleAttributeDefinition getDomainNameAttribute(String childName) {
        if ("resolved".equals(childName)) {
            return ExposeModelResourceResolved.DOMAIN_NAME;
        }
        if ("expression".equals(childName)) {
            return ExposeModelResourceExpression.DOMAIN_NAME;
        }
        throw JmxMessages.MESSAGES.unknownChild(childName);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)this.domainName, null, (OperationStepHandler)new JMXWriteAttributeHandler((AttributeDefinition)this.domainName));
    }

    private static class ShowModelRemove
    extends RestartParentResourceRemoveHandler {
        private final ManagedAuditLogger auditLoggerInfo;
        private final JmxAuthorizer authorizer;

        private ShowModelRemove(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
            this.authorizer = authorizer;
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, this.auditLoggerInfo, this.authorizer, verificationHandler, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    private static class ShowModelAdd
    extends RestartParentResourceAddHandler {
        private final ManagedAuditLogger auditLoggerInfo;
        private final JmxAuthorizer authorizer;
        private final SimpleAttributeDefinition domainName;
        private final SimpleAttributeDefinition[] otherAttributes;

        private ShowModelAdd(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, SimpleAttributeDefinition domainName, SimpleAttributeDefinition ... otherAttributes) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
            this.authorizer = authorizer;
            this.domainName = domainName;
            this.otherAttributes = otherAttributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            this.domainName.validateAndSet(operation, model);
            if (this.otherAttributes.length > 0) {
                for (SimpleAttributeDefinition attr : this.otherAttributes) {
                    attr.validateAndSet(operation, model);
                }
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, this.auditLoggerInfo, this.authorizer, verificationHandler, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    class JMXWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        JMXWriteAttributeHandler(AttributeDefinition attr) {
            super("subsystem", new AttributeDefinition[]{attr});
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, ExposeModelResource.this.auditLoggerInfo, ExposeModelResource.this.authorizer, verificationHandler, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }
}

