/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;

class ObjectNameAddressUtil {
    private static final EscapedCharacter[] ESCAPED_KEY_CHARACTERS;

    ObjectNameAddressUtil() {
    }

    static ObjectName createObjectName(String domain, PathAddress pathAddress) {
        if (pathAddress.size() == 0) {
            return ModelControllerMBeanHelper.createRootObjectName(domain);
        }
        StringBuilder sb = new StringBuilder(domain);
        sb.append(":");
        boolean first = true;
        for (PathElement element : pathAddress) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            ObjectNameAddressUtil.escapeKey(ESCAPED_KEY_CHARACTERS, sb, element.getKey());
            sb.append("=");
            ObjectNameAddressUtil.escapeValue(sb, element.getValue());
        }
        try {
            return ObjectName.getInstance(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw JmxMessages.MESSAGES.cannotCreateObjectName(e, pathAddress);
        }
    }

    static PathAddress resolvePathAddress(String domain, Resource rootResource, ObjectName name) {
        if (!name.getDomain().equals(domain)) {
            return null;
        }
        if (name.equals(ModelControllerMBeanHelper.createRootObjectName(domain))) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, rootResource, properties);
    }

    private static PathAddress searchPathAddress(PathAddress address, Resource resource, Map<String, String> properties) {
        if (properties.size() == 0) {
            return address;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PathElement childElement = PathElement.pathElement((String)ObjectNameAddressUtil.replaceEscapedCharactersInKey(entry.getKey()), (String)ObjectNameAddressUtil.replaceEscapedCharactersInValue(entry.getValue()));
            Resource child = resource.getChild(childElement);
            if (child == null) continue;
            HashMap<String, String> childProps = new HashMap<String, String>(properties);
            childProps.remove(entry.getKey());
            PathAddress foundAddr = ObjectNameAddressUtil.searchPathAddress(address.append(new PathElement[]{childElement}), child, childProps);
            if (foundAddr == null) continue;
            return foundAddr;
        }
        return null;
    }

    static PathAddress toPathAddress(String domain, ImmutableManagementResourceRegistration registry, ObjectName name) {
        if (!name.getDomain().equals(domain)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        if (name.equals(ModelControllerMBeanHelper.createRootObjectName(domain))) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, registry, properties);
    }

    private static PathAddress searchPathAddress(PathAddress address, ImmutableManagementResourceRegistration registry, Map<String, String> properties) {
        if (properties.size() == 0) {
            return address;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PathAddress childAddress = PathAddress.pathAddress((String)ObjectNameAddressUtil.replaceEscapedCharactersInKey(entry.getKey()), (String)ObjectNameAddressUtil.replaceEscapedCharactersInValue(entry.getValue()));
            ImmutableManagementResourceRegistration subModel = registry.getSubModel(childAddress);
            if (subModel == null) continue;
            HashMap<String, String> childProps = new HashMap<String, String>(properties);
            childProps.remove(entry.getKey());
            PathAddress foundAddr = ObjectNameAddressUtil.searchPathAddress(address.append(childAddress), subModel, childProps);
            if (foundAddr == null) continue;
            return foundAddr;
        }
        return null;
    }

    private static void escapeKey(EscapedCharacter[] escapedCharacters, StringBuilder sb, String value) {
        for (EscapedCharacter escapedCharacter : escapedCharacters) {
            value = value.replace(escapedCharacter.getChar().toString(), escapedCharacter.getEscaped());
        }
        sb.append(value);
    }

    private static void escapeValue(StringBuilder sb, String value) {
        boolean quoted;
        boolean containsAsterix = value.contains("*");
        boolean containsBackslash = value.contains("\\");
        boolean containsColon = value.contains(":");
        boolean containsEquals = value.contains("=");
        boolean containsNewLine = value.contains("\n");
        boolean containsQuestionMark = value.contains("?");
        boolean containsQuote = value.contains("\"");
        boolean bl = quoted = containsAsterix || containsBackslash || containsColon || containsEquals || containsNewLine || containsQuestionMark || containsQuote;
        if (quoted) {
            String replaced = value;
            sb.append("\"");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsAsterix, replaced, "*", "\\*");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsBackslash, replaced, "\\", "\\\\");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsNewLine, replaced, "\n", "\\n");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsQuestionMark, replaced, "?", "\\?");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsQuote, replaced, "\"", "\\\"");
            sb.append(replaced);
            sb.append("\"");
        } else {
            sb.append(value);
        }
    }

    private static String checkAndReplace(boolean condition, String original, String search, String replacement) {
        if (condition) {
            return original.replace(search, replacement);
        }
        return original;
    }

    private static String replaceEscapedCharactersInKey(String escaped) {
        if (escaped.contains("%x")) {
            for (EscapedCharacter escapedCharacter : ESCAPED_KEY_CHARACTERS) {
                escaped = escaped.replace(escapedCharacter.getEscaped(), escapedCharacter.getChar());
            }
        }
        return escaped;
    }

    private static String replaceEscapedCharactersInValue(String escaped) {
        if (escaped.startsWith("\"") && escaped.endsWith("\"")) {
            boolean containsAsterix = escaped.contains("\\*");
            boolean containsBackslash = escaped.contains("\\\\");
            boolean containsNewLine = escaped.contains("\\n");
            boolean containsQuestionMark = escaped.contains("\\?");
            boolean containsQuote = escaped.contains("\\\"");
            String replaced = escaped.substring(1, escaped.length() - 1);
            replaced = ObjectNameAddressUtil.checkAndReplace(containsAsterix, replaced, "\\*", "*");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsBackslash, replaced, "\\\\", "\\");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsNewLine, replaced, "\\n", "\n");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsQuestionMark, replaced, "\\?", "?");
            replaced = ObjectNameAddressUtil.checkAndReplace(containsQuote, replaced, "\\\"", "\"");
            return replaced;
        }
        return escaped;
    }

    static {
        ArrayList<EscapedCharacter> keys = new ArrayList<EscapedCharacter>();
        keys.add(new EscapedCharacter(Character.valueOf('*')));
        keys.add(new EscapedCharacter(Character.valueOf('?')));
        keys.add(new EscapedCharacter(Character.valueOf(':')));
        keys.add(new EscapedCharacter(Character.valueOf('=')));
        keys.add(new EscapedCharacter(Character.valueOf(',')));
        ESCAPED_KEY_CHARACTERS = keys.toArray(new EscapedCharacter[keys.size()]);
    }

    private static class EscapedCharacter {
        private final String ch;
        private final String hexPart;
        private final String escaped;

        EscapedCharacter(Character ch) {
            this.ch = String.valueOf(ch);
            this.hexPart = Integer.toHexString(ch.charValue());
            this.escaped = "%x" + this.hexPart;
        }

        String getChar() {
            return this.ch;
        }

        String getEscaped() {
            return this.escaped;
        }
    }
}

