/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldClassIntrospector
implements EEClassIntrospector,
Service<EEClassIntrospector> {
    private static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"weld", "weldClassIntrospector"});
    private final InjectedValue<BeanManagerImpl> beanManager = new InjectedValue();
    private final ConcurrentMap<Class<?>, InjectionTarget<?>> injectionTargets = new ConcurrentHashMap();

    public static WeldClassIntrospector install(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) {
        WeldClassIntrospector introspector = new WeldClassIntrospector();
        serviceTarget.addService(WeldClassIntrospector.serviceName(deploymentUnit), (Service)introspector).addDependency(BeanManagerService.serviceName(deploymentUnit), BeanManagerImpl.class, introspector.beanManager).install();
        return introspector;
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(SERVICE_NAME);
    }

    public ManagedReferenceFactory createFactory(Class<?> clazz) {
        final BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        final InjectionTarget injectionTarget = this.getInjectionTarget(clazz);
        return new ManagedReferenceFactory(){

            public ManagedReference getReference() {
                CreationalContext context = beanManager.createCreationalContext(null);
                Object instance = injectionTarget.produce(context);
                injectionTarget.inject(instance, context);
                injectionTarget.postConstruct(instance);
                return new WeldManagedReference(injectionTarget, context, instance);
            }
        };
    }

    private InjectionTarget getInjectionTarget(Class<?> clazz) {
        InjectionTarget target = (InjectionTarget)this.injectionTargets.get(clazz);
        if (target != null) {
            return target;
        }
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager.getValue();
        InjectionTarget newTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(clazz));
        target = this.injectionTargets.putIfAbsent(clazz, newTarget);
        if (target == null) {
            return newTarget;
        }
        return target;
    }

    public ManagedReference createInstance(Object instance) {
        BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        InjectionTarget injectionTarget = this.getInjectionTarget(instance.getClass());
        CreationalContext context = beanManager.createCreationalContext(null);
        injectionTarget.inject(instance, context);
        injectionTarget.postConstruct(instance);
        return new WeldManagedReference(injectionTarget, context, instance);
    }

    public InjectedValue<BeanManagerImpl> getBeanManager() {
        return this.beanManager;
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
        this.injectionTargets.clear();
    }

    public EEClassIntrospector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static class WeldManagedReference
    implements ManagedReference {
        private final InjectionTarget injectionTarget;
        private final CreationalContext ctx;
        private final Object instance;

        public WeldManagedReference(InjectionTarget injectionTarget, CreationalContext ctx, Object instance) {
            this.injectionTarget = injectionTarget;
            this.ctx = ctx;
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
            }
            finally {
                this.ctx.release();
            }
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

