/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;

public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private final ServiceName baseName;
    private final Set<BusinessInterfaceDescriptor<?>> localInterfaces;
    private final Set<BusinessInterfaceDescriptor<?>> remoteInterfaces;
    private final Map<Class<?>, ServiceName> viewServices;
    private final Set<Method> removeMethods;
    private final Class<T> ejbClass;
    private final String ejbName;
    private final boolean stateless;
    private final boolean stateful;
    private final boolean singleton;
    private final boolean messageDriven;

    public EjbDescriptorImpl(EJBComponentDescription componentDescription, BeanDeploymentArchiveImpl beanDeploymentArchive, DeploymentReflectionIndex reflectionIndex) {
        SessionBeanComponentDescription description = componentDescription instanceof SessionBeanComponentDescription ? (SessionBeanComponentDescription)componentDescription : null;
        HashSet localInterfaces = new HashSet();
        HashSet remoteInterfaces = new HashSet();
        ResourceLoader loader = (ResourceLoader)beanDeploymentArchive.getServices().get(ResourceLoader.class);
        this.ejbClass = loader.classForName(componentDescription.getEJBClassName());
        if (componentDescription.getViews() != null) {
            for (ViewDescription view : componentDescription.getViews()) {
                if (description == null || this.getMethodIntf(view) == MethodIntf.LOCAL) {
                    String viewClassName = view.getViewClassName();
                    localInterfaces.add(new BusinessInterfaceDescriptorImpl(beanDeploymentArchive, viewClassName));
                    continue;
                }
                if (this.getMethodIntf(view) != MethodIntf.REMOTE) continue;
                remoteInterfaces.add(new BusinessInterfaceDescriptorImpl(beanDeploymentArchive, view.getViewClassName()));
            }
        }
        if (componentDescription instanceof StatefulComponentDescription) {
            HashSet<Method> removeMethods = new HashSet<Method>();
            Collection methods = ((StatefulComponentDescription)componentDescription).getRemoveMethods();
            for (StatefulComponentDescription.StatefulRemoveMethod method : methods) {
                for (Class<T> c = this.ejbClass; c != null && c != Object.class; c = c.getSuperclass()) {
                    ClassReflectionIndex index = reflectionIndex.getClassIndex(c);
                    Method m = index.getMethod(method.getMethodIdentifier());
                    if (m == null) continue;
                    removeMethods.add(m);
                }
            }
            this.removeMethods = Collections.unmodifiableSet(removeMethods);
        } else {
            this.removeMethods = Collections.emptySet();
        }
        this.ejbName = componentDescription.getEJBName();
        HashMap<Class, ServiceName> viewServices = new HashMap<Class, ServiceName>();
        for (ViewDescription view : componentDescription.getViews()) {
            viewServices.put(loader.classForName(view.getViewClassName()), view.getServiceName());
        }
        this.viewServices = Collections.unmodifiableMap(viewServices);
        this.localInterfaces = localInterfaces;
        this.remoteInterfaces = remoteInterfaces;
        this.baseName = componentDescription.getServiceName();
        this.stateless = componentDescription.isStateless();
        this.messageDriven = componentDescription.isMessageDriven();
        this.stateful = componentDescription.isStateful();
        this.singleton = componentDescription.isSingleton();
    }

    private MethodIntf getMethodIntf(ViewDescription view) {
        if (view instanceof EJBViewDescription) {
            EJBViewDescription ejbView = (EJBViewDescription)view;
            return ejbView.getMethodIntf();
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return this.ejbClass;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return this.remoteInterfaces;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isMessageDriven() {
        return this.messageDriven;
    }

    public ServiceName getBaseName() {
        return this.baseName;
    }

    public ServiceName getCreateServiceName() {
        return this.baseName.append(new String[]{"CREATE"});
    }

    public ServiceName getStartServiceName() {
        return this.baseName.append(new String[]{"START"});
    }

    public Map<Class<?>, ServiceName> getViewServices() {
        return this.viewServices;
    }
}

