/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbServices;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldInterceptorBindingsService
implements Service<InterceptorBindings> {
    private volatile InterceptorBindings interceptorBindings;
    private final InjectedValue<WeldBootstrapService> weldContainer = new InjectedValue();
    private final String beanArchiveId;
    private final String ejbName;
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldInterceptorBindingsService"});

    public WeldInterceptorBindingsService(String beanArchiveId, String ejbName) {
        this.beanArchiveId = beanArchiveId;
        this.ejbName = ejbName;
    }

    public void start(StartContext startContext) throws StartException {
        BeanManagerImpl beanManager = (BeanManagerImpl)((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanArchiveId);
        EjbDescriptor descriptor = beanManager.getEjbDescriptor(this.ejbName);
        SessionBean bean = null;
        if (descriptor != null) {
            bean = beanManager.getBean(descriptor);
        }
        this.interceptorBindings = this.getInterceptorBindings(this.ejbName, beanManager);
    }

    protected InterceptorBindings getInterceptorBindings(String ejbName, BeanManagerImpl beanManager) {
        EjbServices ejbServices = (EjbServices)beanManager.getServices().get(EjbServices.class);
        if (ejbServices instanceof ForwardingEjbServices) {
            ejbServices = ((ForwardingEjbServices)ejbServices).delegate();
        }
        InterceptorBindings interceptorBindings = null;
        if (ejbServices instanceof WeldEjbServices) {
            interceptorBindings = ((WeldEjbServices)ejbServices).getBindings(ejbName);
        }
        return interceptorBindings;
    }

    public void stop(StopContext stopContext) {
        this.interceptorBindings = null;
    }

    public InterceptorBindings getValue() throws IllegalStateException, IllegalArgumentException {
        return this.interceptorBindings;
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }
}

