/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.weld.WeldMessages;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class ModuleGroupSingletonProvider
extends SingletonProvider {
    public static final Map<ClassLoader, Set<ClassLoader>> deploymentClassLoaders = new ConcurrentHashMap<ClassLoader, Set<ClassLoader>>();

    public static void addClassLoaders(ClassLoader topLevel, Set<ClassLoader> allClassLoaders) {
        deploymentClassLoaders.put(topLevel, allClassLoaders);
    }

    public static void removeClassLoader(ClassLoader topLevel) {
        deploymentClassLoaders.remove(topLevel);
    }

    public <T> Singleton<T> create(Class<? extends T> type) {
        return new TCCLSingleton();
    }

    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private volatile Map<ClassLoader, T> store = Collections.emptyMap();

        private TCCLSingleton() {
        }

        public T get() {
            T instance = this.store.get(this.findParentModuleCl(this.getClassLoader()));
            if (instance == null) {
                throw WeldMessages.MESSAGES.singletonNotSet(this.getClassLoader());
            }
            return instance;
        }

        public synchronized void set(T object) {
            IdentityHashMap<ClassLoader, T> store = new IdentityHashMap<ClassLoader, T>(this.store);
            ClassLoader classLoader = this.getClassLoader();
            store.put(classLoader, object);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    store.put(cl, object);
                }
            }
            this.store = store;
        }

        public synchronized void clear() {
            ClassLoader classLoader = this.getClassLoader();
            IdentityHashMap<ClassLoader, T> store = new IdentityHashMap<ClassLoader, T>(this.store);
            store.remove(classLoader);
            if (deploymentClassLoaders.containsKey(classLoader)) {
                for (ClassLoader cl : deploymentClassLoaders.get(classLoader)) {
                    store.remove(cl);
                }
            }
            this.store = store;
        }

        public boolean isSet() {
            return this.store.containsKey(this.findParentModuleCl(this.getClassLoader()));
        }

        private ClassLoader findParentModuleCl(ClassLoader classLoader) {
            ClassLoader c;
            for (c = classLoader; c != null && !(c instanceof ModuleClassLoader); c = c.getParent()) {
            }
            return c;
        }

        private ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }

        public T get(String id) {
            return this.get();
        }

        public boolean isSet(String id) {
            return this.isSet();
        }

        public void set(String id, T object) {
            this.set(object);
        }

        public void clear(String id) {
            this.clear();
        }
    }
}

