/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.util.HashMap;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.WeldMessages;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class WeldJpaInjectionServices
implements JpaInjectionServices {
    private DeploymentUnit deploymentUnit;

    public WeldJpaInjectionServices(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        PersistenceContext context = (PersistenceContext)injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class);
        if (context == null) {
            throw WeldMessages.MESSAGES.annotationNotFound(PersistenceContext.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new TransactionScopedEntityManager(scopedPuName, new HashMap(), persistenceUnitService.getEntityManagerFactory());
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        PersistenceUnit context = (PersistenceUnit)injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class);
        if (context == null) {
            throw WeldMessages.MESSAGES.annotationNotFound(PersistenceUnit.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return persistenceUnitService.getEntityManagerFactory();
    }

    public void cleanup() {
        this.deploymentUnit = null;
    }

    private String getScopedPUName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        PersistenceUnitMetadata scopedPu = PersistenceUnitSearch.resolvePersistenceUnitSupplier((DeploymentUnit)deploymentUnit, (String)persistenceUnitName);
        if (null == scopedPu) {
            throw WeldMessages.MESSAGES.couldNotFindPersistenceUnit(persistenceUnitName, deploymentUnit.getName());
        }
        return scopedPu.getScopedPersistenceUnitName();
    }
}

