/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.SlowConsumerPolicy;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.AddressSettingsValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

class AddressSettingAdd
extends AbstractAddStepHandler {
    static final OperationStepHandler INSTANCE = new AddressSettingAdd((AttributeDefinition[])AddressSettingDefinition.ATTRIBUTES);

    private AddressSettingAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep(AddressSettingsValidator.ADD_VALIDATOR, OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HornetQServer server = HornetQActivationService.getHornetQServer(context, operation);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            AddressSettings settings = AddressSettingAdd.createSettings(context, model);
            server.getAddressSettingsRepository().addMatch(address.getLastElement().getValue(), (Object)settings);
        }
    }

    static AddressSettings createSettings(OperationContext context, ModelNode config) throws OperationFailedException {
        AddressSettings settings = new AddressSettings();
        if (config.hasDefined(AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.getName())) {
            AddressFullMessagePolicy addressPolicy = AddressFullMessagePolicy.valueOf((String)AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.resolveModelAttribute(context, config).asString());
            settings.setAddressFullMessagePolicy(addressPolicy);
        }
        if (config.hasDefined(CommonAttributes.DEAD_LETTER_ADDRESS.getName())) {
            settings.setDeadLetterAddress(AddressSettingAdd.asSimpleString(CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, config), null));
        }
        if (config.hasDefined(AddressSettingDefinition.LAST_VALUE_QUEUE.getName())) {
            settings.setLastValueQueue(AddressSettingDefinition.LAST_VALUE_QUEUE.resolveModelAttribute(context, config).asBoolean());
        }
        if (config.hasDefined(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.getName())) {
            settings.setMaxDeliveryAttempts(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.resolveModelAttribute(context, config).asInt());
        }
        if (config.hasDefined(AddressSettingDefinition.MAX_SIZE_BYTES.getName())) {
            settings.setMaxSizeBytes(AddressSettingDefinition.MAX_SIZE_BYTES.resolveModelAttribute(context, config).asLong());
        }
        if (config.hasDefined(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.getName())) {
            settings.setMessageCounterHistoryDayLimit(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.resolveModelAttribute(context, config).asInt());
        }
        if (config.hasDefined(CommonAttributes.EXPIRY_ADDRESS.getName())) {
            settings.setExpiryAddress(AddressSettingAdd.asSimpleString(CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, config), null));
        }
        if (config.hasDefined(AddressSettingDefinition.REDELIVERY_DELAY.getName())) {
            settings.setRedeliveryDelay(AddressSettingDefinition.REDELIVERY_DELAY.resolveModelAttribute(context, config).asLong());
        }
        if (config.hasDefined(AddressSettingDefinition.REDISTRIBUTION_DELAY.getName())) {
            settings.setRedistributionDelay(AddressSettingDefinition.REDISTRIBUTION_DELAY.resolveModelAttribute(context, config).asLong());
        }
        if (config.hasDefined(AddressSettingDefinition.PAGE_SIZE_BYTES.getName())) {
            settings.setPageSizeBytes(AddressSettingDefinition.PAGE_SIZE_BYTES.resolveModelAttribute(context, config).asLong());
        }
        if (config.hasDefined(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.getName())) {
            settings.setPageCacheMaxSize(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.resolveModelAttribute(context, config).asInt());
        }
        if (config.hasDefined(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.getName())) {
            settings.setSendToDLAOnNoRoute(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.resolveModelAttribute(context, config).asBoolean());
        }
        if (config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.getName())) {
            settings.setSlowConsumerCheckPeriod(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.resolveModelAttribute(context, config).asLong());
        }
        if (config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_POLICY.getName())) {
            SlowConsumerPolicy slowConsumerPolicy = SlowConsumerPolicy.valueOf((String)AddressSettingDefinition.SLOW_CONSUMER_POLICY.resolveModelAttribute(context, config).asString());
            settings.setSlowConsumerPolicy(slowConsumerPolicy);
        }
        if (config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.getName())) {
            settings.setSlowConsumerThreshold(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.resolveModelAttribute(context, config).asLong());
        }
        return settings;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }
}

