/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

@Deprecated
public class MessagingDescriptions {
    static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private MessagingDescriptions() {
    }

    public static ModelNode getGetLastSentMessageId(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, "get-last-sent-message-id", "jms-server", "session-id", ModelType.STRING, false, ModelType.STRING, true);
        ModelNode addr = result.get(new String[]{"request-properties", "address-name"});
        addr.get("description").set(bundle2.getString("jms-server.address-name"));
        addr.get("type").set(ModelType.STRING);
        addr.get("required").set(true);
        addr.get("nillable").set(false);
        return result;
    }

    public static ModelNode getGetRoles(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)"get-roles", (String)"hornetq-server", (String)"address-match", (ModelType)ModelType.STRING, (boolean)false, (ModelType)ModelType.LIST, (boolean)true);
        ModelNode valueType = result.get(new String[]{"reply-properties", "value-type"});
        ModelNode roleName = valueType.get("name");
        roleName.get("description").set(bundle2.getString("security-role.name"));
        roleName.get("type").set(ModelType.STRING);
        roleName.get("nillable").set(false);
        roleName.get("min-length").set(1);
        for (SimpleAttributeDefinition attr : SecurityRoleDefinition.ATTRIBUTES) {
            String attrName = attr.getName();
            ModelNode attrNode = valueType.get(attrName);
            attrNode.get("description").set(bundle2.getString("security-role." + attrName));
            attrNode.get("type").set(ModelType.BOOLEAN);
            attrNode.get("nillable").set(false);
        }
        return result;
    }

    public static ModelNode getListScheduledMessages(Locale locale, boolean forJMS, boolean json) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        String opName = json ? "list-scheduled-messages-as-json" : "list-scheduled-messages";
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)opName, (String)"queue");
        ModelNode repProps = result.get("reply-properties");
        repProps.get("description").set(bundle2.getString("queue." + opName + ".reply"));
        if (json) {
            repProps.get("type").set(ModelType.STRING);
        } else {
            repProps.get("type").set(ModelType.LIST);
            if (forJMS) {
                MessagingDescriptions.populateJMSMessageDescription(bundle2, repProps.get("value-type"));
            } else {
                MessagingDescriptions.populateCoreMessageDescription(bundle2, repProps.get("value-type"));
            }
        }
        return result;
    }

    public static ModelNode getListMessages(Locale locale, boolean forJMS, boolean json) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        String opName = json ? "list-messages-as-json" : "list-messages";
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)opName, (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        ModelNode repProps = result.get("reply-properties");
        repProps.get("description").set(bundle2.getString("queue.list-messages.reply"));
        if (json) {
            repProps.get("type").set(ModelType.STRING);
        } else {
            repProps.get("type").set(ModelType.LIST);
            if (forJMS) {
                MessagingDescriptions.populateJMSMessageDescription(bundle2, repProps.get("value-type"));
            } else {
                MessagingDescriptions.populateCoreMessageDescription(bundle2, repProps.get("value-type"));
            }
        }
        return result;
    }

    private static void populateFilterParam(ResourceBundle bundle2, ModelNode filter) {
        filter.get("description").set(bundle2.getString("queue.filter"));
        filter.get("type").set(ModelType.STRING);
        filter.get("required").set(false);
        filter.get("nillable").set(true);
    }

    private static void populateCoreMessageDescription(ResourceBundle bundle2, ModelNode node) {
        ModelNode msgId = node.get("messageID");
        msgId.get("description").set(bundle2.getString("queue.message.messageID"));
        msgId.get("type").set(ModelType.STRING);
        msgId.get("nillable").set(false);
        ModelNode userId = node.get("userID");
        userId.get("description").set(bundle2.getString("queue.message.userID"));
        userId.get("type").set(ModelType.STRING);
        userId.get("nillable").set(true);
        ModelNode address = node.get("address");
        address.get("description").set(bundle2.getString("queue.message.address"));
        address.get("type").set(ModelType.STRING);
        address.get("nillable").set(false);
        ModelNode type = node.get("type");
        type.get("description").set(bundle2.getString("queue.message.type"));
        type.get("type").set(ModelType.INT);
        type.get("nillable").set(false);
        type.get("allowed").add(0);
        type.get("allowed").add(2);
        type.get("allowed").add(3);
        type.get("allowed").add(4);
        type.get("allowed").add(5);
        type.get("allowed").add(6);
        ModelNode durable = node.get("durable");
        durable.get("description").set(bundle2.getString("queue.message.durable"));
        durable.get("type").set(ModelType.INT);
        durable.get("nillable").set(false);
        ModelNode expiration = node.get("expiration");
        expiration.get("description").set(bundle2.getString("queue.message.expiration"));
        expiration.get("type").set(ModelType.LONG);
        expiration.get("nillable").set(false);
        ModelNode timestamp = node.get("timestamp");
        timestamp.get("description").set(bundle2.getString("queue.message.timestamp"));
        timestamp.get("type").set(ModelType.LONG);
        timestamp.get("nillable").set(false);
        ModelNode priority = node.get("priority");
        priority.get("description").set(bundle2.getString("queue.message.priority"));
        priority.get("type").set(ModelType.INT);
        priority.get("nillable").set(false);
        priority.get("min").set(0);
        priority.get("max").set(9);
    }

    public static ModelNode getCountMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"count-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return result;
    }

    public static ModelNode getRemoveMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"remove-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    private static void populateMessageIDParam(ResourceBundle bundle2, ModelNode messageID, boolean forJMS) {
        messageID.get("description").set(bundle2.getString("queue.message-id"));
        messageID.get("type").set(forJMS ? ModelType.STRING : ModelType.LONG);
        messageID.get("required").set(false);
        messageID.get("nillable").set(true);
    }

    public static ModelNode getRemoveMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"remove-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getExpireMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"expire-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getExpireMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"expire-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getSendMessageToDeadLetterAddress(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"send-message-to-dead-letter-address", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.send-message-to-dead-letter-address.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getSendMessagesToDeadLetterAddress(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"send-messages-to-dead-letter-address", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.send-messages-to-dead-letter-address.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getChangeMessagePriority(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"change-message-priority", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        MessagingDescriptions.populatePriorityParam(bundle2, result.get(new String[]{"request-properties", "new-priority"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getChangeMessagesPriority(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"change-messages-priority", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        MessagingDescriptions.populatePriorityParam(bundle2, result.get(new String[]{"request-properties", "new-priority"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    private static void populatePriorityParam(ResourceBundle bundle2, ModelNode priority) {
        priority.get("description").set(bundle2.getString("queue.change-message-priority.new-priority"));
        priority.get("type").set(ModelType.INT);
        priority.get("required").set(true);
        priority.get("min").set(0);
        priority.get("max").set(9);
    }

    public static ModelNode getMoveMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"move-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        MessagingDescriptions.populateOtherQueueParam(bundle2, result.get(new String[]{"request-properties", "other-queue-name"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.move-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    private static void populateOtherQueueParam(ResourceBundle bundle2, ModelNode otherQueue) {
        otherQueue.get("description").set(bundle2.getString("queue.move-message.other-queue-name"));
        otherQueue.get("type").set(ModelType.STRING);
        otherQueue.get("required").set(true);
        otherQueue.get("nillable").set(false);
    }

    public static ModelNode getMoveMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"move-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        MessagingDescriptions.populateOtherQueueParam(bundle2, result.get(new String[]{"request-properties", "other-queue-name"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.move-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getListSubscriptionsOperation(Locale locale, String operationName) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getNoArgSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)"jms-topic", (ModelType)ModelType.LIST, (boolean)true);
        ModelNode queueName = result.get(new String[]{"reply-properties", "value-type", "queueName"});
        queueName.get("description").set(bundle2.getString("jms-topic.list-subscriptions.queueName"));
        queueName.get("type").set(ModelType.STRING);
        queueName.get("nillable").set(false);
        ModelNode clientID = result.get(new String[]{"reply-properties", "value-type", "clientID"});
        clientID.get("description").set(bundle2.getString("jms-topic.list-subscriptions.clientID"));
        clientID.get("type").set(ModelType.STRING);
        clientID.get("nillable").set(false);
        ModelNode selector = result.get(new String[]{"reply-properties", "value-type", "selector"});
        selector.get("description").set(bundle2.getString("jms-topic.list-subscriptions.selector"));
        selector.get("type").set(ModelType.STRING);
        selector.get("nillable").set(true);
        ModelNode name = result.get(new String[]{"reply-properties", "value-type", "name"});
        name.get("description").set(bundle2.getString("jms-topic.list-subscriptions.name"));
        name.get("type").set(ModelType.STRING);
        name.get("nillable").set(false);
        ModelNode durable = result.get(new String[]{"reply-properties", "value-type", "durable"});
        durable.get("description").set(bundle2.getString("jms-topic.list-subscriptions.durable"));
        durable.get("type").set(ModelType.BOOLEAN);
        durable.get("nillable").set(false);
        ModelNode messageCount = result.get(new String[]{"reply-properties", "value-type", "messageCount"});
        messageCount.get("description").set(bundle2.getString("jms-topic.list-subscriptions.messageCount"));
        messageCount.get("type").set(ModelType.LONG);
        messageCount.get("nillable").set(false);
        messageCount.get("unit").set(MeasurementUnit.NONE.getName());
        ModelNode deliveringCount = result.get(new String[]{"reply-properties", "value-type", "deliveringCount"});
        deliveringCount.get("description").set(bundle2.getString("jms-topic.list-subscriptions.deliveringCount"));
        deliveringCount.get("type").set(ModelType.INT);
        deliveringCount.get("nillable").set(false);
        deliveringCount.get("unit").set(MeasurementUnit.NONE.getName());
        ModelNode consumers = result.get(new String[]{"reply-properties", "value-type", "consumers"});
        consumers.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers"));
        consumers.get("type").set(ModelType.LIST);
        consumers.get("nillable").set(false);
        consumers.get("min-length").set(0);
        ModelNode consumerId = consumers.get(new String[]{"value-type", "consumerID"});
        consumerId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.consumerID"));
        consumerId.get("type").set(ModelType.LONG);
        consumerId.get("nillable").set(false);
        ModelNode connectionId = consumers.get(new String[]{"value-type", "connectionID"});
        connectionId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.connectionID"));
        connectionId.get("type").set(ModelType.STRING);
        connectionId.get("nillable").set(false);
        ModelNode sessionId = consumers.get(new String[]{"value-type", "sessionID"});
        sessionId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.sessionID"));
        sessionId.get("type").set(ModelType.STRING);
        sessionId.get("nillable").set(true);
        ModelNode browseOnly = consumers.get(new String[]{"value-type", "browseOnly"});
        browseOnly.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.browseOnly"));
        browseOnly.get("type").set(ModelType.BOOLEAN);
        browseOnly.get("nillable").set(false);
        ModelNode creationTime = consumers.get(new String[]{"value-type", "creationTime"});
        creationTime.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.creationTime"));
        creationTime.get("type").set(ModelType.LONG);
        creationTime.get("nillable").set(false);
        return result;
    }

    public static ModelNode getListMessagesForSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getListMessagesBase(bundle2, "list-messages-for-subscription");
        ModelNode replyProps = result.get("reply-properties");
        replyProps.get("description").set(bundle2.getString("jms-topic.list-messages-for-subscription.reply"));
        replyProps.get("type").set(ModelType.LIST);
        MessagingDescriptions.populateJMSMessageDescription(bundle2, replyProps.get("value-type"));
        return result;
    }

    private static void populateJMSMessageDescription(ResourceBundle bundle2, ModelNode node) {
        ModelNode priority = node.get("JMSPriority");
        priority.get("description").set(bundle2.getString("jms-queue.message.JMSPriority"));
        priority.get("type").set(ModelType.INT);
        ModelNode timestamp = node.get("JMSTimestamp");
        timestamp.get("description").set(bundle2.getString("jms-queue.message.JMSTimestamp"));
        timestamp.get("type").set(ModelType.LONG);
        ModelNode expiration = node.get("JMSExpiration");
        expiration.get("description").set(bundle2.getString("jms-queue.message.JMSExpiration"));
        expiration.get("type").set(ModelType.LONG);
        ModelNode deliveryMode = node.get("JMSDeliveryMode");
        deliveryMode.get("description").set(bundle2.getString("jms-queue.message.JMSDeliveryMode"));
        deliveryMode.get("type").set(ModelType.STRING);
        deliveryMode.get("nillable").set(false);
        deliveryMode.get("allowed").add("PERSISTENT");
        deliveryMode.get("allowed").add("NON_PERSISTENT");
        ModelNode messageId = node.get("JMSMessageID");
        messageId.get("description").set(bundle2.getString("jms-queue.message.JMSMessageID"));
        messageId.get("type").set(ModelType.STRING);
        messageId.get("nillable").set(true);
    }

    public static ModelNode getListMessagesForSubscriptionAsJSON(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getListMessagesBase(bundle2, "list-messages-for-subscription-as-json");
        ModelNode replyProps = result.get("reply-properties");
        replyProps.get("description").set("jms-topic.list-messages-for-subscription-as-json.reply");
        replyProps.get("type").set(ModelType.STRING);
        return result;
    }

    private static ModelNode getListMessagesBase(ResourceBundle bundle2, String operationName) {
        ModelNode result = new ModelNode();
        result.get("operation-name").set(operationName);
        result.get("description").set(bundle2.getString("jms-topic." + operationName));
        ModelNode nameProp = result.get(new String[]{"request-properties", "queue-name"});
        nameProp.get("description").set(bundle2.getString("jms-topic.list-messages-for-subscription.queue-name"));
        nameProp.get("type").set(ModelType.STRING);
        nameProp.get("required").set(true);
        nameProp.get("nillable").set(false);
        return result;
    }

    public static ModelNode getCountMessagesForSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("count-messages-for-subscription");
        result.get("description").set(bundle2.getString("jms-topic.count-messages-for-subscription"));
        ModelNode reqProps = result.get("request-properties");
        ModelNode clientId = reqProps.get(CommonAttributes.CLIENT_ID.getName());
        clientId.get("description").set(bundle2.getString("jms-topic.client-id"));
        clientId.get("type").set(ModelType.STRING);
        clientId.get("nillable").set(false);
        ModelNode subscriptionName = reqProps.get("subscription-name");
        subscriptionName.get("description").set(bundle2.getString("jms-topic.subscription-name"));
        subscriptionName.get("type").set(ModelType.STRING);
        subscriptionName.get("nillable").set(false);
        ModelNode filter = reqProps.get(CommonAttributes.FILTER.getName());
        filter.get("description").set(bundle2.getString("jms-topic.filter"));
        filter.get("type").set(ModelType.STRING);
        filter.get("nillable").set(true);
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getDropDurableSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("drop-durable-subscription");
        result.get("description").set(bundle2.getString("jms-topic.drop-durable-subscription"));
        ModelNode reqProps = result.get("request-properties");
        ModelNode clientId = reqProps.get(CommonAttributes.CLIENT_ID.getName());
        clientId.get("description").set(bundle2.getString("jms-topic.client-id"));
        clientId.get("type").set(ModelType.STRING);
        clientId.get("nillable").set(false);
        ModelNode subscriptionName = reqProps.get("subscription-name");
        subscriptionName.get("description").set(bundle2.getString("jms-topic.subscription-name"));
        subscriptionName.get("type").set(ModelType.STRING);
        subscriptionName.get("nillable").set(false);
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    private static ModelNode addParamsParameterDescription(ModelNode operation, String description, ResourceBundle bundle2) {
        ModelNode node = operation.get(new String[]{"request-properties", "param"});
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle2.getString(description));
        node.get("required").set(false);
        node.get("expressions-allowed").set(true);
        node.get("value-type").set(ModelType.STRING);
        return node;
    }

    public static ModelNode getPathResource(Locale locale, String path) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString(path + ".path"));
        for (AttributeDefinition attr : MessagingPathHandlers.getAttributes(path)) {
            attr.addResourceAttributeDescription(bundle2, "path", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getPathAdd(Locale locale, String path) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("path.add"));
        for (AttributeDefinition attr : MessagingPathHandlers.getAttributes(path)) {
            attr.addOperationParameterDescription(bundle2, "path", node);
        }
        return node;
    }

    public static ModelNode getPathRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "path");
    }

    static ModelNode getAcceptorAdd(Locale locale, AttributeDefinition ... attrs) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("acceptor.add"));
        for (AttributeDefinition attr : attrs) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "acceptor.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorAdd(Locale locale, AttributeDefinition ... attrs) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector.add"));
        for (AttributeDefinition attr : attrs) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "connector.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    public static ModelNode getPooledConnectionFactory(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("pooled-connection-factory"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle2, node, true);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    private static void addPooledConnectionFactoryProperties(ResourceBundle bundle2, ModelNode node, boolean resource) {
        for (AttributeDefinition attr : ConnectionFactoryAttribute.getDefinitions(PooledConnectionFactoryDefinition.ATTRIBUTES)) {
            if (resource) {
                attr.addResourceAttributeDescription(bundle2, "pooled-connection-factory", node);
            } else {
                attr.addOperationParameterDescription(bundle2, "pooled-connection-factory", node);
            }
            if (!attr.getName().equals(ConnectionFactoryAttributes.Common.CONNECTOR.getName())) continue;
            String propType = resource ? "attributes" : "request-properties";
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(ModelType.STRING);
        }
    }

    public static ModelNode getPooledConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("pooled-connection-factory.add"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle2, node, false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getDescriptionOnlyOperation(Locale locale, String operationName, String descriptionPrefix) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix);
    }

    public static ModelNode getNoArgSimpleReplyOperation(Locale locale, String operationName, String descriptionPrefix, ModelType replyType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getNoArgSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (ModelType)replyType, (boolean)describeReply);
    }

    public static ModelNode getSingleParamSimpleReplyOperation(Locale locale, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType replyType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (String)paramName, (ModelType)paramType, (boolean)paramNillable, (ModelType)replyType, (boolean)describeReply);
    }

    public static ModelNode getSingleParamSimpleListReplyOperation(Locale locale, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType listValueType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (String)paramName, (ModelType)paramType, (boolean)paramNillable, (ModelType)listValueType, (boolean)describeReply);
    }

    public static ModelNode getNoArgSimpleListReplyOperation(Locale locale, String operationName, String descriptionPrefix, ModelType listValueType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getNoArgSimpleListReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (ModelType)listValueType, (boolean)describeReply);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

