/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.hornetq.jms.bridge.ConnectionFactoryFactory;
import org.hornetq.jms.bridge.DestinationFactory;
import org.hornetq.jms.bridge.JMSBridge;
import org.hornetq.jms.bridge.QualityOfServiceMode;
import org.hornetq.jms.bridge.impl.JMSBridgeImpl;
import org.hornetq.jms.bridge.impl.JNDIConnectionFactoryFactory;
import org.hornetq.jms.bridge.impl.JNDIDestinationFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.SecurityActions;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeService;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class JMSBridgeAdd
extends AbstractAddStepHandler {
    public static final JMSBridgeAdd INSTANCE = new JMSBridgeAdd();

    private JMSBridgeAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : JMSBridgeDefinition.JMS_BRIDGE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        for (AttributeDefinition attributeDefinition : JMSBridgeDefinition.JMS_TARGET_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        for (AttributeDefinition attributeDefinition : JMSBridgeDefinition.JMS_SOURCE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                String moduleName = JMSBridgeAdd.this.resolveAttribute(JMSBridgeDefinition.MODULE, context, model);
                JMSBridge bridge = JMSBridgeAdd.this.createJMSBridge(context, model);
                String bridgeName = address.getLastElement().getValue();
                JMSBridgeService bridgeService = new JMSBridgeService(moduleName, bridgeName, bridge);
                ServiceName bridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName);
                ServiceBuilder jmsBridgeServiceBuilder = context.getServiceTarget().addService(bridgeServiceName, (Service)bridgeService).addListener((ServiceListener)verificationHandler).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER).setInitialMode(ServiceController.Mode.ACTIVE);
                Services.addServerExecutorDependency((ServiceBuilder)jmsBridgeServiceBuilder, bridgeService.getExecutorInjector(), (boolean)false);
                if (JMSBridgeAdd.this.dependsOnLocalResources(model, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource((ServiceBuilder<JMSBridge>)jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource((ServiceBuilder<JMSBridge>)jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_DESTINATION);
                }
                if (JMSBridgeAdd.this.dependsOnLocalResources(model, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource((ServiceBuilder<JMSBridge>)jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource((ServiceBuilder<JMSBridge>)jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_DESTINATION);
                }
                newControllers.add(jmsBridgeServiceBuilder.install());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private boolean dependsOnLocalResources(ModelNode model, AttributeDefinition attr) throws OperationFailedException {
        return !model.hasDefined(attr.getName());
    }

    private void addDependencyForJNDIResource(ServiceBuilder<JMSBridge> builder, ModelNode model, OperationContext context, AttributeDefinition attribute) throws OperationFailedException {
        String jndiName = attribute.resolveModelAttribute(context, model).asString();
        builder.addDependency(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
    }

    private JMSBridge createJMSBridge(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties sourceContextProperties = this.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT, context, model);
        String sourceConnectionFactoryName = JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory((Hashtable)sourceContextProperties, sourceConnectionFactoryName);
        String sourceDestinationName = JMSBridgeDefinition.SOURCE_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory sourceDestinationFactory = new JNDIDestinationFactory((Hashtable)sourceContextProperties, sourceDestinationName);
        Properties targetContextProperties = this.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT, context, model);
        String targetConnectionFactoryName = JMSBridgeDefinition.TARGET_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory targetCff = new JNDIConnectionFactoryFactory((Hashtable)targetContextProperties, targetConnectionFactoryName);
        String targetDestinationName = JMSBridgeDefinition.TARGET_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory targetDestinationFactory = new JNDIDestinationFactory((Hashtable)targetContextProperties, targetDestinationName);
        String sourceUsername = this.resolveAttribute(JMSBridgeDefinition.SOURCE_USER, context, model);
        String sourcePassword = this.resolveAttribute(JMSBridgeDefinition.SOURCE_PASSWORD, context, model);
        String targetUsername = this.resolveAttribute(JMSBridgeDefinition.TARGET_USER, context, model);
        String targetPassword = this.resolveAttribute(JMSBridgeDefinition.TARGET_PASSWORD, context, model);
        String selector = this.resolveAttribute(CommonAttributes.SELECTOR, context, model);
        long failureRetryInterval = JMSBridgeDefinition.FAILURE_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        int maxRetries = JMSBridgeDefinition.MAX_RETRIES.resolveModelAttribute(context, model).asInt();
        QualityOfServiceMode qosMode = QualityOfServiceMode.valueOf((String)JMSBridgeDefinition.QUALITY_OF_SERVICE.resolveModelAttribute(context, model).asString());
        int maxBatchSize = JMSBridgeDefinition.MAX_BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        long maxBatchTime = JMSBridgeDefinition.MAX_BATCH_TIME.resolveModelAttribute(context, model).asLong();
        String subName = this.resolveAttribute(JMSBridgeDefinition.SUBSCRIPTION_NAME, context, model);
        String clientID = this.resolveAttribute(JMSBridgeDefinition.CLIENT_ID, context, model);
        boolean addMessageIDInHeader = JMSBridgeDefinition.ADD_MESSAGE_ID_IN_HEADER.resolveModelAttribute(context, model).asBoolean();
        String moduleName = this.resolveAttribute(JMSBridgeDefinition.MODULE, context, model);
        ClassLoader oldTccl = SecurityActions.getContextClassLoader();
        try {
            ModuleIdentifier moduleID;
            if (moduleName != null) {
                moduleID = ModuleIdentifier.create((String)moduleName);
                Module module = Module.getCallerModuleLoader().loadModule(moduleID);
                SecurityActions.setThreadContextClassLoader((ClassLoader)module.getClassLoader());
            }
            moduleID = new JMSBridgeImpl((ConnectionFactoryFactory)sourceCff, (ConnectionFactoryFactory)targetCff, (DestinationFactory)sourceDestinationFactory, (DestinationFactory)targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader);
            return moduleID;
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTccl);
        }
    }

    private Properties resolveContextProperties(AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode contextModel = attribute.resolveModelAttribute(context, model);
        if (!contextModel.isDefined()) {
            return null;
        }
        Properties contextProperties = new Properties();
        for (Property property : contextModel.asPropertyList()) {
            contextProperties.put(property.getName(), property.getValue().asString());
        }
        return contextProperties;
    }

    private String resolveAttribute(SimpleAttributeDefinition attr, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode node = attr.resolveModelAttribute(context, model);
        return node.isDefined() ? node.asString() : null;
    }
}

